/*
 * LedMatrix.h
 *
 *  Created on: 25 january 2016
 *      Author: CPV
 */

#ifndef __LEDMATRIX_H__
#define __LEDMATRIX_H__

#include "stdint.h"

#define PIXELS  (17)
#define CENTER_LED  (PIXELS-1)

#define CENTER_LED_X  (P0_10)
#define CENTER_LED_Y  (P0_11)


typedef enum
{
    black = 0,
    red,
    green,
    orange
}
LedMatrixColor_t;


class CLedMatrixPixel
{
public:
    CLedMatrixPixel(uint8_t x, uint8_t y, LedMatrixColor_t color=black) 
    { 
        m_x = x; 
        m_y = y; 
        m_color = color;
    }
    
    uint8_t x(void) { return m_x; }
    uint8_t y(void) { return m_y; }

    LedMatrixColor_t color(void) { return m_color; }
    CLedMatrixPixel& operator= (LedMatrixColor_t color) { m_color = color; return *this; }
    
private:
    uint8_t m_x;
    uint8_t m_y;
    LedMatrixColor_t m_color;
};


class CLedMatrix
{
public:
    CLedMatrix(void) { initialise(); }
    void putPixel(uint8_t nr, LedMatrixColor_t color);
    void tick(void);
    
    void debugLedEnable(bool enable) { m_maxPixel = enable==true? PIXELS-1 : PIXELS; }
    void debugLed(LedMatrixColor_t color) 
    { 
        if (m_maxPixel!=PIXELS) setCenterLed(color); 
    }
    
private:
    void initialise(void);
    void set(CLedMatrixPixel pixel, LedMatrixColor_t color);
    void setCenterLed(LedMatrixColor_t color);
    
    uint8_t m_acitvePixel;
    uint8_t m_maxPixel;
};


extern DigitalOut led17g;
extern DigitalOut led17r;

#endif /* __LEDMATRIX_H__ */
