#include "atmegatron.h"
//#include "chip.h"  // For SystemCoreClock only.

//#define F_CPU  SystemCoreClock


unsigned long master_tick;  //current tick.  used for all timing of lfos, arp and envs
volatile uint16_t master_index = 0;  //position in master_output wavetable
unsigned char master_output[WAVE_LEN];  //output wavetable
unsigned char master_output_ch2[WAVE_LEN];  //output wavetable
unsigned long master_ocr1 = 10227;  //interrupt frequency (sets pitch of synth)
unsigned long master_sf = 7040;  //sample frequency, ocr1 derived from this


// Set the sample frequency (pitch)
void Master_Let_SampleFreq(void)
{
	// Has the pitch actually changed?
	if (Pitch_Get_PitchChanged()==true)
	{
		// Calculate new sample frequency.
		master_sf = Pitch_Get_FreqCalc()*WAVE_LEN;
		// Convert sample frequency to interrupt ticks.
		master_ocr1 = /*Chip_Clock_GetSystemClockRate() / */ master_sf;
		//master_ocr1 = F_CPU/master_sf;  //convert to interrupt time
		if (master_ocr1>65535)
		{
			// Highest possible value for ocr1 (lowest freq)
			master_ocr1 = 65535;
		}
		if (master_ocr1<100)
		{
			// Lowest possible value for ocr1.  Any lower and code in interrupt doesn't have time to complete.
			// Worked out by trial and error.
			master_ocr1 = 100;
		}
		//master_ocr1 >>= 2; // cpv
	}
}


unsigned long Master_Get_SampleFreq(void)
{
	return master_sf;
}
