#include "mbed.h"

#ifndef _VISION_H
#define _VISION_H

struct Point {
    float x;
    float y;
};

struct lineScanData {
    uint8_t mostWhiteIndex;
    uint16_t maxLightValue;
    uint8_t rightEdgeIndex;
    uint8_t leftEdgeIndex;
    struct Point rightEdgePosition;
    struct Point leftEdgePosition;
    Timer age;
};

class Vision
{
    public:

    Vision();
    bool processTasks();
    void saveData(uint16_t* line);
    struct lineScanData processLine();
    bool lightCompensation;
    struct lineScanData getRoadData();

    private:
    
    uint16_t lineData[128];
    bool newDataToProcess;
    struct lineScanData currentRoadData;
    Timer dataAge;
    void lineScanLightAdjust();
    struct Point getPixelPosition(uint8_t pixelIndex);
};

#endif