#include "mbed.h"

#ifndef _PIDCONTROLLER_H
#define _PIDCONTROLLER_H

class PID
{
    public:

    PID();
    void reset(void);
    void setReference(float ref);
    void setCoefficients(float Kp, float Ki, float Kd);
    void setOutputLimits(float min, float max);
    float processNewValue(float input);
    float getControllerOutput(void);
    float getIntegralTerm(void);
    
    private:

    float target;    
    float kp, ki, kd;
    float pout,iout,dout;
    float integral, derivative;
    float error, previous_error;
    float outputMin, outputMax;
    
    Timer t;
};

#endif