#include "PIDcontroller.h"


PID::PID()
{
    integral = 0;
    previous_error = 0;
    
    outputMin = -1.0;
    outputMax = 1.0;
    
    target = 0;
    kp = 1.0;
    ki = 0;
    kd = 0;
    
    t.start();
    t.reset();
}

void PID::reset(void)
{
    integral = 0;
    previous_error = 0;
    t.reset();
}

void PID::setReference(float ref)
{
    target = ref;
}

void PID::setCoefficients(float Kp, float Ki, float Kd)
{
    kp = Kp;
    ki = Ki;
    kd = Kd;
}

void PID::setOutputLimits(float min, float max)
{
    if(min > max)
        return;
    
    outputMin = min;
    outputMax = max;
}

float PID::processNewValue(float input)
{
    float dt;
    error = target - input;
    
    if(kp != 0)
        pout = kp*error;
    else
        pout = 0;
    // TODO: see if there is a need of a clamp on integral term
    if((ki!= 0) || (kd != 0))
    {
        dt = t.read();
        t.reset();
            
        if(ki != 0)
        {
            integral = integral + error*dt;
            iout = ki*integral;
        }
        else
            iout = 0;
        
        if(kd != 0)
        {
            derivative = (error - previous_error)/dt;
            dout = kd*derivative;
        }
        else
            dout = 0;
    }
    else
    {
        iout = 0;
        dout = 0;
    }
    previous_error = error;
    
    return getControllerOutput();
}

float PID::getControllerOutput(void)
{
    float output;
    
    output = pout + iout + dout;
    
    if(output > outputMax)
        return outputMax;
    
    if(output < outputMin)
        return outputMin;
        
    return output;
}

float PID::getIntegralTerm(void)
{
    return integral;
}
