#include "mbed.h"
#include "TFC.h"

#ifndef _MOTORCONTROL_H
#define _MOTORCONTROL_H

#define MOTSAMPLECOUNT 100
#define BATSAMPLECOUNT 50

class Motors
{
    public:

    Motors();
    void start();
    void stop();
    void saveBatteryVoltageMeasure(uint16_t ADCresult);
    void saveMotorCurrentMeasure(uint16_t MotA_ADCresult, uint16_t MotB_ADCresult);
    float getWheelSpeed(char mot);
    float getWheelRPS(char mot);
    float getAverageSpeed();
    float getCarSpeed();
    void setFixedPWMMode(void);
    void setRegulatedPWMMode(void);
    void processTasks();
    float getMotCurrent(char mot);
    float getMotPWM(char mot);
    float getAverageMotCurrent(char mot);
    float getAverageBatteryVoltage();
    void setFixedPWMValue(float pwm);
    void setSpeedTargetValue(float speed);
    
    float getSpeedError();

    private:
    
    bool PWMRegulatedMode;
    int16_t fixedPWM;
    
    int16_t motorAPWM[MOTSAMPLECOUNT];
    int16_t motorBPWM[MOTSAMPLECOUNT];
    float motorACurrent[MOTSAMPLECOUNT];
    float motorBCurrent[MOTSAMPLECOUNT];
    uint16_t batteryVoltage[BATSAMPLECOUNT];
    
    uint8_t motorCurrentIndex;
    uint8_t batVoltageIndex;
    
    int16_t nextPWM;
//    int16_t torqueDiffAvg;
    uint8_t motorDriveIndex;
    int16_t currentMotAPWM;
    int16_t currentMotBPWM;
    
    int32_t speedTarget;
    int32_t speederror1000000;
};

#endif