#define TARGET_STM32F4XX
#define NUM_OF_BUTTONS 32
#define NUM_OF_HAT_BUTTONS 4
#define SYSTEM_CLOCK_HZ                 96000000  // 96MHz 
 
// Joystick button input pin assignments.  
//
// You can wire up to 32 GPIO ports to buttons (equipped with 
// momentary switches).  Connect each switch between the desired 
// GPIO port and ground (J9 pin 12 or 14).  When the button is pressed, 
// we'll tell the host PC that the corresponding joystick button is 
// pressed.  We debounce the keystrokes in software, so you can simply 
// wire directly to pushbuttons with no additional external hardware.
//
// Note that we assign 24 buttons by default, even though the USB
// joystick interface can handle up to 32 buttons.  VP itself only
// allows mapping of up to 24 buttons in the preferences dialog 
// (although it can recognize 32 buttons internally).  If you want 
// more buttons, you can reassign pins that are assigned by default
// as LedWiz outputs.  To reassign a pin, find the pin you wish to
// reassign in the LedWizPortMap array below, and change the pin name 
// there to NC (for Not Connected).  You can then change one of the
// "NC" entries below to the reallocated pin name.  The limit is 32
// buttons total.
//
// (If you're using TLC5940 chips to control outputs, many of the
// GPIO pins that are mapped to LedWiz outputs in the default
// mapping can be reassigned as keys, since the TLC5940 outputs
// take over for the GPIO pins.  The exceptions are the pins that
// are reassigned to control the TLC5940 chips.)
//
// Note: PTD1 (pin J2-12) should NOT be assigned as a button input,
// as this pin is physically connected on the KL25Z to the on-board
// indicator LED's blue segment.
 
PinName buttonMap[] = {
    PA_6,       // button 1
    PA_7,       // button 2
    PA_8,       // button 3
    PA_9,       // button 4
    PA_10,      // button 5
    PA_13,      // button 6
    PA_14,      // button 7
    PA_15,      // button 8
    PB_1,       // button 9
    PB_2,       // button 10
    PB_4,       // button 11
    PB_5,       // button 12
    PB_6,       // button 13
    PB_7,       // button 14
    PB_8,       // button 15
    PB_9,       // button 16
    PB_10,      // button 17
    PB_12,      // button 18
    PC_4,       // button 19
    PC_5,       // button 20      
    PC_6,       // button 21
    PC_7,       // button 22
    PC_8,       // button 23
    PC_9,       // button 24
    NC,         // button 25
    NC,         // button 26
    NC,         // button 27
    NC,         // button 28
    NC,         // button 29
    NC,         // button 30
    NC,         // button 31
    NC          // button 32
};
 
PinName hatMap[] = {
    PC_2,       // button 1
    PC_3,       // button 2
    PC_10,      // button 3
    PC_12,      // button 4
    NC,         // button 5
    NC,         // button 6
    NC,         // button 7
    NC          // button 8
};