/* mbed USBJoystick Library Demo
 * Copyright (c) 2012, v01:  Initial version, WH,
 *                           Modified USBMouse code ARM Limited.
 *                           (c) 2010-2011 mbed.org, MIT License
 *               2016, v02:  Updated USBDevice Lib, Added waitForConnect, Updated 32 bits button 
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, inclumosig without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUmosiG BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "config.h"
#include "USBJoystick.h"

//#define LANDTIGER 1

// number of elements in an array
#define countof(x) (sizeof(x)/sizeof((x)[0]))

// The Simulator Device
USBJoystick joystick;

// Variables for Button input
DigitalIn *buttonDigIn[NUM_OF_BUTTONS];  // config.h
DigitalIn *hatDigIn[NUM_OF_HAT_BUTTONS];  // config.h

// Variables for Heartbeat and Status monitoring
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut heartbeatLED(LED4);

AnalogIn xi(A0);
AnalogIn yi(A1);
AnalogIn fi(A2);
AnalogIn bi(A3);
AnalogIn ri(A4);
AnalogIn ti(A5);

Ticker heartbeat;
Serial pc(USBTX, USBRX); // tx, rx

// Heartbeat monitor
void pulse() {
  heartbeatLED = !heartbeatLED;
}

void heartbeat_start() {
  heartbeatLED=1;
  heartbeat.attach(&pulse, 0.5);
}

void heartbeat_stop() {
  heartbeat.detach();
}

// button state
struct ButtonState
{
    // current on/off state
    int pressed;
    
    // Sticky time remaining for current state.  When a
    // state transition occurs, we set this to a debounce
    // period.  Future state transitions will be ignored
    // until the debounce time elapses.
    int t;
} buttonState[NUM_OF_BUTTONS];

// timer for button reports
static Timer buttonTimer;

// initialize the button inputs
void initButtons()
{
    // create the digital inputs
    for (int i = 0 ; i < countof(buttonDigIn) ; ++i)
    {
        if (i < countof(buttonMap) && buttonMap[i] != NC)
            buttonDigIn[i] = new DigitalIn(buttonMap[i]);
        else
            buttonDigIn[i] = 0;
    }
    
    // start the button timer
    buttonTimer.start();
}


// read the button input state
uint32_t readButtons()
{
    // start with all buttons off
    uint32_t buttons = 0;
    
    // figure the time elapsed since the last scan
    int dt = buttonTimer.read_ms();
    
    // reset the timef for the next scan
    buttonTimer.reset();
    
    // scan the button list
    uint32_t bit = 1;
    DigitalIn **di = buttonDigIn;
    ButtonState *bs = buttonState;
    for (int i = 0 ; i < countof(buttonDigIn) ; ++i, ++di, ++bs, bit <<= 1)
    {
        // read this button
        if (*di != 0)
        {
            // deduct the elapsed time since the last update
            // from the button's remaining sticky time
            bs->t -= dt;
            if (bs->t < 0)
                bs->t = 0;
            
            // If the sticky time has elapsed, note the new physical
            // state of the button.  If we still have sticky time
            // remaining, ignore the physical state; the last state
            // change persists until the sticky time elapses so that
            // we smooth out any "bounce" (electrical transients that
            // occur when the switch contact is opened or closed).
            if (bs->t == 0)
            {
                // get the new physical state
                int pressed = !(*di)->read();
                
                // update the button's logical state if this is a change
                if (pressed != bs->pressed)
                {
                    // store the new state
                    bs->pressed = pressed;
                    
                    // start a new sticky period for debouncing this
                    // state change
                    bs->t = 25;
                }
            }
            
            // if it's pressed, OR its bit into the state
            if (bs->pressed)
                buttons |= bit;
        }
    }
    
    // return the new button list
    return buttons;
}

// timer for hat button reports
static Timer hatTimer;

// button state
struct HatState
{
    // current on/off state
    int pressed;
    
    // Sticky time remaining for current state.  When a
    // state transition occurs, we set this to a debounce
    // period.  Future state transitions will be ignored
    // until the debounce time elapses.
    int t;
} hatState[NUM_OF_HAT_BUTTONS];

// initialize the hat inputs
void initHat()
{
    // create the digital inputs
    for (int i = 0 ; i < countof(hatDigIn) ; ++i)
    {
        if (i < countof(hatMap) && hatMap[i] != NC)
            hatDigIn[i] = new DigitalIn(hatMap[i]);
        else
            hatDigIn[i] = 0;
    }
}

// read the button input state
uint32_t readHat()
{
    // start with all buttons off
    uint8_t hat = 0;
    
    // figure the time elapsed since the last scan
    int dt = hatTimer.read_ms();
    
    // reset the timef for the next scan
    hatTimer.reset();
    
    // scan the button list
    uint8_t bit = 1;
    DigitalIn **di = hatDigIn;
    HatState *bs = hatState;
    for (int i = 0 ; i < countof(hatDigIn) ; ++i, ++di, ++bs, bit <<= 1)
    {
        // read this button
        if (*di != 0)
        {
            // deduct the elapsed time since the last update
            // from the button's remaining sticky time
            bs->t -= dt;
            if (bs->t < 0)
                bs->t = 0;
            
            // If the sticky time has elapsed, note the new physical
            // state of the button.  If we still have sticky time
            // remaining, ignore the physical state; the last state
            // change persists until the sticky time elapses so that
            // we smooth out any "bounce" (electrical transients that
            // occur when the switch contact is opened or closed).
            if (bs->t == 0)
            {
                // get the new physical state
                int pressed = !(*di)->read();
                
                // update the button's logical state if this is a change
                if (pressed != bs->pressed)
                {
                    // store the new state
                    bs->pressed = pressed;
                    
                    // start a new sticky period for debouncing this
                    // state change
                    bs->t = 25;
                }
            }
            
            // if it's pressed, OR its bit into the state
            if (bs->pressed)
                hat |= bit;
        }
    }
    
    // return the new button list
    return hat;
}

int main() {
  //uint16_t i = 0;
  int16_t throttle = 0;
  int16_t rudder = 0;    
  int16_t flaps = 0;
  int16_t breaks = 0;
  int16_t x = 0;
  int16_t y = 0;
  //int32_t radius = 120;
  //int32_t angle = 0;
  //uint8_t tmp = 0;
  uint32_t buttons = 0;    
  uint8_t hat = 0;    
    
  pc.printf("Hello World from Joystick!\n\r");
  
  initButtons();
  initHat();
  heartbeat_start();

  while (1) {
/*    // Basic Joystick
    throttle = (i >> 8) & 0xFF;  // value -127 .. 128
    rudder = (i >> 8) & 0xFF;    // value -127 .. 128        
    flaps = (i >> 8) & 0xFF;     // value -127 .. 128        
    breaks = (i >> 8) & 0xFF;    // value -127 .. 128        

#if (BUTTONS4 == 1)        
    buttons = (i >> 8) & 0x0F;   // value    0 ..  15, one bit per button     
#endif        
#if (BUTTONS8 == 1)        
    buttons = (i >> 8) & 0xFF;   // value    0 .. 255, one bit per button     
#endif        
#if (BUTTONS32 == 1)        
    tmp     = (i >> 8) & 0xFF;   // value    0 .. 255, one bit per button     
    buttons =           (( tmp <<  0) & 0x000000FF);
    buttons = buttons | ((~tmp <<  8) & 0x0000FF00);
    buttons = buttons | (( tmp << 16) & 0x00FF0000);
    buttons = buttons | ((~tmp << 24) & 0xFF000000);
#endif        

#if (HAT4 == 1)        
    hat    = (i >> 8) & 0x03;   // value 0, 1, 2, 3 or 4 for neutral 
#endif
#if (HAT8 == 1)
    hat    = (i >> 8) & 0x07;   // value 0..7 or 8 for neutral
#endif        
    i++;
        
    //x = cos((double)angle*3.14/180.0)*radius;  // value -127 .. 128
    //y = sin((double)angle*3.14/180.0)*radius;  // value -127 .. 128
    //angle += 3;        
*/

    buttons = readButtons();
    hat = readHat();
    
    x = int(((double)xi.read() - 0.5) * 254);
    y = int(((double)yi.read() - 0.5) * 254);
    flaps = int(((double)fi.read() - 0.5) * 254);
    breaks = int(((double)bi.read() - 0.5) * 254);
    rudder = int(((double)ri.read() - 0.5) * 254);
    throttle = int(((double)ti.read() - 0.5) * 254);

    joystick.update(throttle, rudder, flaps, breaks, x, y, buttons, hat);
    wait(0.001);
  }
    
  //pc.printf("Bye World!\n\r");                           
}