/* mbed USBJoystick Library
 * Copyright (c) 2012, v01:  Initial version, WH,
 *                           Modified USBMouse code ARM Limited.
 *                           (c) 2010-2011 mbed.org, MIT License
 *               2016, v02:  Updated USBDevice Lib, Added waitForConnect, Updated 32 bits button
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, inclumosig without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUmosiG BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#include "stdint.h"
#include "USBJoystick.h"

bool USBJoystick::update(int16_t t, int16_t r, int16_t f, int16_t b, int16_t x, int16_t y, uint32_t buttons, uint8_t hat)
{

    _t = t;
    _r = r;
    _f = f;
    _b = b;
    _x = x;
    _y = y;
    _buttons = buttons;
    _hat = hat;

    return update();
}

bool USBJoystick::update()
{
    PID_REPORT report;

    // Fill the report according to the Joystick Descriptor
    report.data[0] = _t & 0xff;
    report.data[1] = _r & 0xff;
    report.data[2] = _f & 0xff;
    report.data[3] = _b & 0xff;
    report.data[4] = _x & 0xff;
    report.data[5] = _y & 0xff;


#if (BUTTONS4 == 1)
//Hat and 4 Buttons
//   report.data[4] = ((_buttons & 0x0f) << 4) | (_hat & 0x0f) ;
//   report.length = 5;


//Use 4 bit padding for hat4 or hat8
    report.data[6] = (_hat & 0x0f) ;

//Use 4 bit padding for buttons
    report.data[7] = (_buttons & 0x0f) ;
    report.length = 8;
#endif

#if (BUTTONS8 == 1)
//Hat and first 4 Buttons
//   report.data[4] = ((_buttons & 0x0f) << 4) | (_hat & 0x0f) ;
//
//Use bit padding for last 4 Buttons
//   report.data[5] =  (_buttons & 0xf0) >> 4;
//   report.length = 6;

//Use 4 bit padding for hat4 or hat8
    report.data[6] = (_hat & 0x0f) ;

//Use 8 bits for buttons
    report.data[7] = (_buttons & 0xff) ;
    report.length = 8;
#endif

#if (BUTTONS32 == 1)
//Use 4 bit padding for hat4 or hat8
    report.data[6] = (_hat & 0x0f) ;

//No bit padding for 32 buttons
    report.data[7] = (_buttons >>  0) & 0xff;
    report.data[8] = (_buttons >>  8) & 0xff;
    report.data[9] = (_buttons >> 16) & 0xff;
    report.data[10] = (_buttons >> 24) & 0xff;
    report.length = 11;
#endif

    return send(&report);
}

bool USBJoystick::throttle(int16_t t)
{
    _t = t;
    return update();
}

bool USBJoystick::rudder(int16_t r)
{
    _r = r;
    return update();
}

bool USBJoystick::flaps(int16_t f)
{
    _f = f;
    return update();
}

bool USBJoystick::breaks(int16_t b)
{
    _b = b;
    return update();
}

bool USBJoystick::move(int16_t x, int16_t y)
{
    _x = x;
    _y = y;
    return update();
}

bool USBJoystick::buttons(uint32_t buttons)
{
    _buttons = buttons;
    return update();
}

bool USBJoystick::hat(uint8_t hat)
{
    _hat = hat;
    return update();
}


void USBJoystick::_init()
{
    _t = -127;
    _r = -127;
    _f = -127;
    _b = -127;
    _x = 0;
    _y = 0;
    _buttons = 0x00000000;
    _hat = 0x00;
}


uint8_t * USBJoystick::stringIinterfaceDesc()
{
    static uint8_t stringIinterfaceDescriptor[] = {
        0x08,               //bLength
        STRING_DESCRIPTOR,  //bDescriptorType 0x03
        'S',0,              //bString iInterface - PID
        'i',0,
        'm',0,
        'u',0,
        'l',0,
        'a',0,
        't',0,
        'o',0,
        'r',0,
    };
    return stringIinterfaceDescriptor;
}

uint8_t * USBJoystick::stringIproductDesc()
{
    static uint8_t stringIproductDescriptor[] = {
        0x16,                                                       //bLength
        STRING_DESCRIPTOR,                                          //bDescriptorType 0x03
        'C',0,                                                      //bString iProduct - PID device
        'o',0,
        'n',0,
        'd',0,
        'o',0,
        'r',0,
        '-',0,
        'S',0,
        'i',0,
        'm',0
    };
    return stringIproductDescriptor;
}

uint8_t * USBJoystick::reportDesc()
{
    static uint8_t reportDescriptor[] = {

        USAGE_PAGE(1), 0x01,           // Generic Desktop
        LOGICAL_MINIMUM(1), 0x00,      // Logical_Minimum (0)
        USAGE(1), 0x04,                // Usage (Joystick)
        COLLECTION(1), 0x01,           // Application
        USAGE_PAGE(1), 0x02,            // Simulation Controls
        USAGE(1), 0xBB,                 // Throttle
        USAGE(1), 0xBA,                 // Rudder
        USAGE(1), 0xC3,                 // Wing Flaps
        USAGE(1), 0xB6,                 // Dive Breaks
        LOGICAL_MINIMUM(1), 0x81,       // -127
        LOGICAL_MAXIMUM(1), 0x7f,       // 127
        REPORT_SIZE(1), 0x08,
        REPORT_COUNT(1), 0x02,
        INPUT(1), 0x02,                 // Data, Variable, Absolute
        USAGE_PAGE(1), 0x01,            // Generic Desktop
        USAGE(1), 0x01,                 // Usage (Pointer)
        COLLECTION(1), 0x00,            // Physical
        USAGE(1), 0x30,                 // X
        USAGE(1), 0x31,                 // Y
//  8 bit values
        LOGICAL_MINIMUM(1), 0x81,       // -127
        LOGICAL_MAXIMUM(1), 0x7f,       // 127
        REPORT_SIZE(1), 0x08,
        REPORT_COUNT(1), 0x02,
        INPUT(1), 0x02,                 // Data, Variable, Absolute
// 16 bit values
//                 LOGICAL_MINIMUM(1), 0x00,       // 0
//                 LOGICAL_MAXIMUM(2), 0xff, 0x7f, // 32767
//                 REPORT_SIZE(1), 0x10,
//                 REPORT_COUNT(1), 0x02,
//                 INPUT(1), 0x02,                 // Data, Variable, Absolute

        END_COLLECTION(0),

#if (HAT4 == 1)
// 4 Position Hat Switch
        USAGE(1), 0x39,                 // Usage (Hat switch)
        LOGICAL_MINIMUM(1), 0x00,       // 0
        LOGICAL_MAXIMUM(1), 0x03,       // 3
        PHYSICAL_MINIMUM(1), 0x00,      // Physical_Minimum (0)
        PHYSICAL_MAXIMUM(2), 0x0E, 0x01, // Physical_Maximum (270)
        UNIT(1), 0x14,                  // Unit (Eng Rot:Angular Pos)
        REPORT_SIZE(1), 0x04,
        REPORT_COUNT(1), 0x01,
        INPUT(1), 0x02,                 // Data, Variable, Absolute
#endif
#if (HAT8 == 1)
// 8 Position Hat Switch
        USAGE(1), 0x39,                 // Usage (Hat switch)
        LOGICAL_MINIMUM(1), 0x00,       // 0
        LOGICAL_MAXIMUM(1), 0x07,       // 7
        PHYSICAL_MINIMUM(1), 0x00,      // Physical_Minimum (0)
        PHYSICAL_MAXIMUM(2), 0x3B, 0x01, // Physical_Maximum (315)
        UNIT(1), 0x14,                  // Unit (Eng Rot:Angular Pos)
        REPORT_SIZE(1), 0x04,
        REPORT_COUNT(1), 0x01,
        INPUT(1), 0x02,                 // Data, Variable, Absolute
#endif

// Padding 4 bits
        REPORT_SIZE(1), 0x01,
        REPORT_COUNT(1), 0x04,
        INPUT(1), 0x01,                 // Constant


#if (BUTTONS4 == 1)
// 4 Buttons
        USAGE_PAGE(1), 0x09,            // Buttons
        USAGE_MINIMUM(1), 0x01,         // 1
        USAGE_MAXIMUM(1), 0x04,         // 4
        LOGICAL_MINIMUM(1), 0x00,       // 0
        LOGICAL_MAXIMUM(1), 0x01,       // 1
        REPORT_SIZE(1), 0x01,
        REPORT_COUNT(1), 0x04,
        UNIT_EXPONENT(1), 0x00,         // Unit_Exponent (0)
        UNIT(1), 0x00,                  // Unit (None)
        INPUT(1), 0x02,                 // Data, Variable, Absolute

// Padding 4 bits
        REPORT_SIZE(1), 0x01,
        REPORT_COUNT(1), 0x04,
        INPUT(1), 0x01,                 // Constant

#endif
#if (BUTTONS8 == 1)
// 8 Buttons
        USAGE_PAGE(1), 0x09,            // Buttons
        USAGE_MINIMUM(1), 0x01,         // 1
        USAGE_MAXIMUM(1), 0x08,         // 8
        LOGICAL_MINIMUM(1), 0x00,       // 0
        LOGICAL_MAXIMUM(1), 0x01,       // 1
        REPORT_SIZE(1), 0x01,
        REPORT_COUNT(1), 0x08,
        UNIT_EXPONENT(1), 0x00,         // Unit_Exponent (0)
        UNIT(1), 0x00,                  // Unit (None)
        INPUT(1), 0x02,                 // Data, Variable, Absolute
#endif

#if (BUTTONS32 == 1)
// 32 Buttons
        USAGE_PAGE(1), 0x09,            // Buttons
        USAGE_MINIMUM(1), 0x01,         // 1
        USAGE_MAXIMUM(1), 0x20,         // 32
        LOGICAL_MINIMUM(1), 0x00,       // 0
        LOGICAL_MAXIMUM(1), 0x01,       // 1
        REPORT_SIZE(1), 0x01,
        REPORT_COUNT(1), 0x20,
        UNIT_EXPONENT(1), 0x00,         // Unit_Exponent (0)
        UNIT(1), 0x00,                  // Unit (None)
        INPUT(1), 0x02,                 // Data, Variable, Absolute
#endif
#if (FFB == 1)
        PHYSICAL_MINIMUM(1), 0x00,      //   PHYSICAL_MINIMUM (0)
        INPUT(1), 0x02,                 //   INPUT (Data,Var,Abs)
        USAGE_PAGE(1), 0x0f,            //   USAGE_PAGE (Physical Interface Device)
        USAGE(1), 0x21,                 //   USAGE (Set Effect Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        USAGE(1), 0x22,                 //     USAGE (Effect Block Index)
        LOGICAL_MAXIMUM(1), 0x7f,       //     LOGICAL_MAXIMUM (127)
        REPORT_SIZE(1), 0x07,           //     REPORT_SIZE (7)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x24,                 //     USAGE (ROM Flag)
        LOGICAL_MAXIMUM(1), 0x01,       //     LOGICAL_MAXIMUM (1)
        REPORT_SIZE(1), 0x01,           //     REPORT_SIZE (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x25,                 //     USAGE (Effect Type)
        COLLECTION(1), 0x02,            //     COLLECTION (Logical)
        USAGE(1), 0x26,                 //       USAGE (ET Constant Force)
        USAGE(1), 0x27,                 //       USAGE (ET Ramp)
        USAGE(1), 0x30,                 //       USAGE (ET Square)
        USAGE(1), 0x31,                 //       USAGE (ET Sine)
        USAGE(1), 0x32,                 //       USAGE (ET Triangle)
        USAGE(1), 0x33,                 //       USAGE (ET Sawtooth Up)
        USAGE(1), 0x34,                 //       USAGE (ET Sawtooth Down)
        USAGE(1), 0x40,                 //       USAGE (ET Spring)
        USAGE(1), 0x41,                 //       USAGE (ET Damper)
        USAGE(1), 0x42,                 //       USAGE (ET Inertia)
        LOGICAL_MINIMUM(1), 0x01,       //       LOGICAL_MINIMUM (1)
        LOGICAL_MAXIMUM(1), 0x0a,       //       LOGICAL_MAXIMUM (10)
        REPORT_SIZE(1), 0x08,           //       REPORT_SIZE (8)
        OUTPUT(1), 0x00,                //       OUTPUT (Data,Ary,Abs)
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x50,                 //   USAGE (Duration)
        USAGE(1), 0x54,                 //     USAGE (Trigger Repeat Interval)
        LOGICAL_MINIMUM(1), 0x00,       //     LOGICAL_MINIMUM (0)
        LOGICAL_MAXIMUM(2), 0x10, 0x27, //     LOGICAL_MAXIMUM (10000)
        PHYSICAL_MAXIMUM(2), 0x10, 0x27,//     PHYSICAL_MAXIMUM (10000)
        REPORT_SIZE(1), 0x10,           //     REPORT_SIZE (16)
        UNIT(2), 0x03, 0x10,            //     UNIT (Eng Lin:Time)
        UNIT_EXPONENT(1), 0x0d,         //     UNIT_EXPONENT (-3)
        REPORT_COUNT(1), 0x02,          //     REPORT_COUNT (2)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        UNIT_EXPONENT(1), 0x0a,         //     UNIT_EXPONENT (-6)
        USAGE(1), 0x51,                 //     USAGE (Sample Period)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        PHYSICAL_MAXIMUM(1), 0x00,      //     PHYSICAL_MAXIMUM (0)
        UNIT_EXPONENT(1), 0x00,         //     UNIT_EXPONENT (0)
        UNIT(1), 0x00,                  //     UNIT (None)
        USAGE(1), 0x52,                 //     USAGE (Gain)
        USAGE(1), 0x53,                 //     USAGE (Trigger Button)
        LOGICAL_MAXIMUM(1), 0x7f,       //     LOGICAL_MAXIMUM (127)
        REPORT_SIZE(1), 0x08,           //     REPORT_SIZE (8)
        REPORT_COUNT(1), 0x02,          //     REPORT_COUNT (2)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x55,                 //     USAGE (Axes Enable)
        COLLECTION(1), 0x02,            //     COLLECTION (Logical)
        USAGE_PAGE(1), 0x01,            //       USAGE_PAGE (Generic Desktop)
        USAGE(1), 0x01,                 //       USAGE (Pointer)
        COLLECTION(1), 0x00,            //       COLLECTION (Physical)
        USAGE(1), 0x30,                 //         USAGE (X)
        USAGE(1), 0x31,                 //         USAGE (Y)
        USAGE(1), 0x32,                 //         USAGE (Z)
        LOGICAL_MINIMUM(1), 0x01,       //         LOGICAL_MINIMUM (1)
        REPORT_SIZE(1), 0x01,           //         REPORT_SIZE (1)
        REPORT_COUNT(1), 0x03,          //         REPORT_COUNT (3)
        OUTPUT(1), 0x02,                //         OUTPUT (Data,Var,Abs)
        END_COLLECTION(0),              //       END_COLLECTION
        END_COLLECTION(0),              //     END_COLLECTION
        REPORT_COUNT(1), 0x06,          //     REPORT_COUNT (6)
        OUTPUT(1), 0x03,                //     OUTPUT (Cnst,Var,Abs)
        USAGE_PAGE(1), 0x0f,            //     USAGE_PAGE (Physical Interface Device)
        USAGE(1), 0x57,                 //     USAGE (Direction)
        COLLECTION(1), 0x02,            //     COLLECTION (Logical)
        USAGE_PAGE(1), 0x01,            //       USAGE_PAGE (Generic Desktop)
        USAGE(1), 0x01,                 //       USAGE (Pointer)
        COLLECTION(1), 0x00,            //       COLLECTION (Physical)
        USAGE(1), 0x30,                 //         USAGE (X)
        USAGE(1), 0x31,                 //         USAGE (Y)
        USAGE(1), 0x32,                 //         USAGE (Z)
        LOGICAL_MINIMUM(1), 0x00,       //         LOGICAL_MINIMUM (0)
        LOGICAL_MAXIMUM(2), 0xff, 0x00, //         LOGICAL_MAXIMUM (255)
        0xPHYSICAL_MAXIMUM(2)6, 0x68, 0x01, //     PHYSICAL_MAXIMUM (360)
        UNIT(1), 0x14,                  //         UNIT (Eng Rot:Angular Pos)
        REPORT_SIZE(1), 0x08,           //         REPORT_SIZE (8)
        REPORT_COUNT(1), 0x03,          //         REPORT_COUNT (3)
        OUTPUT(1), 0x02,                //         OUTPUT (Data,Var,Abs)
        UNIT(1), 0x00,                  //         UNIT (None)
        PHYSICAL_MAXIMUM(1), 0x00,      //         PHYSICAL_MAXIMUM (0)
        END_COLLECTION(0),              //       END_COLLECTION
        END_COLLECTION(0),              //     END_COLLECTION
        USAGE_PAGE(1), 0x0f,            //     USAGE_PAGE (Physical Interface Device)
        USAGE(1), 0x58,                 //     USAGE (Type Specific Block Offset)
        COLLECTION(1), 0x02,            //     COLLECTION (Logical)
        USAGE(3), 0x01, 0x00, 0x0a, 0x00, //     USAGE (Ordinals:Instance 1)
        USAGE(3), 0x02, 0x00, 0x0a, 0x00, //     USAGE (Ordinals:Instance 2)
        LOGICAL_MAXIMUM(2), 0xfd, 0x7f, //       LOGICAL_MAXIMUM (32765)
        REPORT_SIZE(1), 0x10,           //       REPORT_SIZE (16)
        REPORT_COUNT(1), 0x02,          //       REPORT_COUNT (2)
        OUTPUT(1), 0x02,                //       OUTPUT (Data,Var,Abs)
        END_COLLECTION(0),              //     END_COLLECTION
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE_PAGE(1), 0x0f,            //   USAGE_PAGE (Physical Interface Device)
        USAGE(1), 0x5a,                 //   USAGE (Set Envelope Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x02,             //     REPORT_ID (2)
        USAGE(1), 0x23,                 //     USAGE (Parameter Block Offset)
        LOGICAL_MAXIMUM(2), 0xfd, 0x7f, //     LOGICAL_MAXIMUM (32765)
        REPORT_SIZE(1), 0x0f,           //     REPORT_SIZE (15)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x24,                 //     USAGE (ROM Flag)
        LOGICAL_MAXIMUM(1), 0x01,       //     LOGICAL_MAXIMUM (1)
        REPORT_SIZE(1), 0x01,           //     REPORT_SIZE (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x5b,                 //     USAGE (Attack Level)
        USAGE(1), 0x5d,                 //     USAGE (Fade Level)
        LOGICAL_MAXIMUM(1), 0xff        //     LOGICAL_MAXIMUM (255)
        REPORT_SIZE(1), 0x08,           //     REPORT_SIZE (8)
        REPORT_COUNT(1), 0x02,          //     REPORT_COUNT (2)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x5c,                 //     USAGE (Attack Time)
        USAGE(1), 0x5e,                 //     USAGE (Fade Time)
        LOGICAL_MAXIMUM(2), 0x10, 0x27, //     LOGICAL_MAXIMUM (10000)
        PHYSICAL_MAXIMUM(1), 0x10, 0x27,//     PHYSICAL_MAXIMUM (10000)
        UNIT(2), 0x03, 0x10,            //     UNIT (Eng Lin:Time)
        UNIT_EXPONENT(1), 0x0d,         //     UNIT_EXPONENT (-3)
        REPORT_SIZE(1), 0x10,           //     REPORT_SIZE (16)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        PHYSICAL_MAXIMUM(1), 0x00,      //     PHYSICAL_MAXIMUM (0)
        UNIT(1), 0x00,                  //     UNIT (None)
        UNIT_EXPONENT(1), 0x00,         //     UNIT_EXPONENT (0)
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x5f,                 //   USAGE (Set Condition Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x03,             //     REPORT_ID (3)
        USAGE(1), 0x23,                 //     USAGE (Parameter Block Offset)
        LOGICAL_MAXIMUM(1), 0xfd, 0x7f, //     LOGICAL_MAXIMUM (32765)
        REPORT_SIZE(1), 0x0f,           //     REPORT_SIZE (15)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x24,                 //     USAGE (ROM Flag)
        LOGICAL_MAXIMUM(1), 0x01,       //     LOGICAL_MAXIMUM (1)
        REPORT_SIZE(1), 0x01,           //     REPORT_SIZE (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x60,                 //     USAGE (CP Offset)
        USAGE(1), 0x61,                 //     USAGE (Positive Coefficient)
        USAGE(1), 0x62,                 //     USAGE (Negative Coefficient)
        USAGE(1), 0x63,                 //     USAGE (Positive Saturation)
        USAGE(1), 0x64,                 //     USAGE (Negative Saturation)
        USAGE(1), 0x65,                 //     USAGE (Dead Band)
        LOGICAL_MAXIMUM(1), 0xff        //     LOGICAL_MAXIMUM (255)
        REPORT_SIZE(1), 0x08,           //     REPORT_SIZE (8)
        REPORT_COUNT(1), 0x06,          //     REPORT_COUNT (6)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x6e,                 //   USAGE (Set Periodic Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x04,             //     REPORT_ID (4)
        USAGE(1), 0x23,                 //     USAGE (Parameter Block Offset)
        LOGICAL_MAXIMUM(2), 0xfd, 0x7f, //     LOGICAL_MAXIMUM (32765)
        REPORT_SIZE(1), 0x0f,           //     REPORT_SIZE (15)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x24,                 //     USAGE (ROM Flag)
        LOGICAL_MAXIMUM(1), 0x01,       //     LOGICAL_MAXIMUM (1)
        REPORT_SIZE(1), 0x01,           //     REPORT_SIZE (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x70,                 //     USAGE (Magnitude)
        USAGE(1), 0x6f,                 //     USAGE (Offset)
        USAGE(1), 0x71,                 //     USAGE (Phase)
        LOGICAL_MAXIMUM(2), 0xff, 0x00, //     LOGICAL_MAXIMUM (255)
        REPORT_SIZE(1), 0x08,           //     REPORT_SIZE (8)
        REPORT_COUNT(1), 0x03,          //     REPORT_COUNT (3)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x72,                 //     USAGE (Period)
        LOGICAL_MAXIMUM(2), 0x10, 0x27, //     LOGICAL_MAXIMUM (10000)
        PHYSICAL_MAXIMUM(2), 0x10, 0x27,//     PHYSICAL_MAXIMUM (10000)
        UNIT(2), 0x03, 0x10,            //     UNIT (Eng Lin:Time)
        UNIT_EXPONENT(1), 0x0d,         //     UNIT_EXPONENT (-3)
        REPORT_SIZE(1), 0x10,           //     REPORT_SIZE (16)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        PHYSICAL_MAXIMUM(1), 0x00,      //     PHYSICAL_MAXIMUM (0)
        UNIT(1), 0x00,                  //     UNIT (None)
        UNIT_EXPONENT(1), 0x00,         //     UNIT_EXPONENT (0))
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x73,                 //   USAGE (Set Constant Force Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x05,             //     REPORT_ID (5)
        USAGE(1), 0x23,                 //     USAGE (Parameter Block Offset)
        LOGICAL_MAXIMUM(2), 0xfd, 0x7f, //     LOGICAL_MAXIMUM (32765)
        REPORT_SIZE(1), 0x0f,           //     REPORT_SIZE (15)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x24,                 //     USAGE (ROM Flag)
        LOGICAL_MAXIMUM(1), 0x01,       //     LOGICAL_MAXIMUM (1)
        REPORT_SIZE(1), 0x01,           //     REPORT_SIZE (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x70,                 //     USAGE (Magnitude)
        LOGICAL_MAXIMUM(2), 0xff, 0x00, //     LOGICAL_MAXIMUM (255)
        REPORT_SIZE(1), 0x08,           //     REPORT_SIZE (8)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        COLLECTION(0),                  //   END_COLLECTION
        USAGE(1), 0x74,                 //   USAGE (Set Ramp Force Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x06,             //     REPORT_ID (6)
        USAGE(1), 0x23,                 //     USAGE (Parameter Block Offset)
        LOGICAL_MAXIMUM(2), 0xfd, 0x7f, //     LOGICAL_MAXIMUM (32765)
        REPORT_SIZE(1), 0x0f,           //     REPORT_SIZE (15)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x24,                 //     USAGE (ROM Flag)
        LOGICAL_MAXIMUM(1), 0x01,       //     LOGICAL_MAXIMUM (1)
        REPORT_SIZE(1), 0x01,           //     REPORT_SIZE (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x75,                 //     USAGE (Ramp Start)
        USAGE(1), 0x76,                 //     USAGE (Ramp End)
        LOGICAL_MAXIMUM(2), 0xff, 0x00, //     LOGICAL_MAXIMUM (255)
        REPORT_SIZE(1), 0x08,           //     REPORT_SIZE (8)
        REPORT_COUNT(1), 0x02,          //     REPORT_COUNT (2)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x68,                 //   USAGE (Custom Force Data Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x07,             //     REPORT_ID (7)
        USAGE(1), 0x23,                 //     USAGE (Parameter Block Offset)
        LOGICAL_MAXIMUM(2), 0xfd, 0x7f, //     LOGICAL_MAXIMUM (32765)
        REPORT_SIZE(1), 0x0f,           //     REPORT_SIZE (15)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(3), 0x3b, 0x00, 0x01, 0x00//     USAGE (Generic Desktop:Byte Count)
        LOGICAL_MAXIMUM(2), 0x00, 0x01, //     LOGICAL_MAXIMUM (256)
        REPORT_SIZE(1), 0x09,           //     REPORT_SIZE (9)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x69,                 //     USAGE (Custom Force Data)
        LOGICAL_MAXIMUM(2), 0xff, 0x00, //     LOGICAL_MAXIMUM (255)
        REPORT_SIZE(1), 0x08,           //     REPORT_SIZE (8)
        REPORT_COUNT(2), 0x00, 0x01,    //     REPORT_COUNT (256)
        OUTPUT(2), 0x02, 0x01,          //     OUTPUT (Data,Var,Abs,Buf)
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x66,                 //   USAGE (Download Force Sample)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x08,             //     REPORT_ID (8)
        USAGE_PAGE(1), 0x01,            //     USAGE_PAGE (Generic Desktop)
        USAGE(1), 0x01,                 //     USAGE (Pointer)
        COLLECTION(1), 0x02,            //     COLLECTION (Logical)
        USAGE(1), 0x30,                 //       USAGE (X)
        USAGE(1), 0x31,                 //       USAGE (Y)
        USAGE(1), 0x32,                 //       USAGE (Z)
        LOGICAL_MINIMUM(1), 0x81,       //       LOGICAL_MINIMUM (-127)
        LOGICAL_MAXIMUM(1), 0x7f,       //       LOGICAL_MAXIMUM (127)
        REPORT_SIZE(1), 0x08,           //       REPORT_SIZE (8)
        REPORT_COUNT(1), 0x03,          //       REPORT_COUNT (3)
        OUTPUT(1), 0x02,                //       OUTPUT (Data,Var,Abs)
        END_COLLECTION(0),              //     END_COLLECTION
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE_PAGE(1), 0x0f,            //   USAGE_PAGE (Physical Interface Device)
        USAGE(1), 0x6b,                 //   USAGE (Set Custom Force Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x09,             //     REPORT_ID (9)
        USAGE(1), 0x23,                 //     USAGE (Parameter Block Offset)
        USAGE(1), 0x6c,                 //     USAGE (Custom Force Data Offset)
        USAGE(1), 0x6d,                 //     USAGE (Sample Count)
        LOGICAL_MINIMUM(1), 0x00,       //     LOGICAL_MINIMUM (0)
        LOGICAL_MAXIMUM(2), 0xfd, 0x7f, //     LOGICAL_MAXIMUM (32765)
        REPORT_COUNT(1), 0x03,          //     REPORT_COUNT (3)
        REPORT_SIZE(1), 0x10,           //     REPORT_SIZE (16)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x77,                 //   USAGE (Effect Operation Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x0a,             //     REPORT_ID (10)
        USAGE(1), 0x22,                 //     USAGE (Effect Block Index)
        LOGICAL_MAXIMUM(1), 0x7f,       //     LOGICAL_MAXIMUM (127)
        REPORT_SIZE(1), 0x07,           //     REPORT_SIZE (7)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x24,                 //     USAGE (ROM Flag)
        LOGICAL_MAXIMUM(1), 0x01,       //     LOGICAL_MAXIMUM (1)
        REPORT_SIZE(1), 0x01,           //     REPORT_SIZE (1)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        USAGE(1), 0x78,                 //     USAGE (Effect Operation)
        COLLECTION(1), 0x02,            //     COLLECTION (Logical)
        USAGE(1), 0x79,                 //       USAGE (Op Effect Start)
        USAGE(1), 0x7a,                 //       USAGE (Op Effect Start Solo)
        USAGE(1), 0x7b,                 //       USAGE (Op Effect Stop)
        LOGICAL_MINIMUM(1), 0x01,       //       LOGICAL_MINIMUM (1)
        LOGICAL_MAXIMUM(1), 0x03,       //       LOGICAL_MAXIMUM (3)
        REPORT_SIZE(1), 0x08,           //       REPORT_SIZE (8)
        OUTPUT(1), 0x00,                //       OUTPUT (Data,Ary,Abs)
        END_COLLECTION(0),              //     END_COLLECTION
        USAGE(1), 0x7c,                 //     USAGE (Loop Count)
        LOGICAL_MINIMUM(1), 0x00,       //     LOGICAL_MINIMUM (0)
        LOGICAL_MAXIMUM(2), 0xff, 0x00, //     LOGICAL_MAXIMUM (255)
        OUTPUT(1), 0x02,                //     OUTPUT (Data,Var,Abs)
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x7f,                 //   USAGE (PID Pool Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x01,             //     REPORT_ID (1)
        USAGE(1), 0x80,                 //     USAGE (RAM Pool Size)
        USAGE(1), 0x81,                 //     USAGE (ROM Pool Size)
        USAGE(1), 0x82,                 //     USAGE (ROM Effect Block Count)
        LOGICAL_MAXIMUM(2), 0xfd, 0x7f, //     LOGICAL_MAXIMUM (32765)
        REPORT_COUNT(1), 0x03,          //     REPORT_COUNT (3)
        REPORT_SIZE(1), 0x10,           //     REPORT_SIZE (16)
        FEATURE(1), 0x02,               //     FEATURE (Data,Var,Abs)
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x92,                 //   USAGE (PID State Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x02,             //     REPORT_ID (2)
        USAGE(1), 0x22,                 //     USAGE (Effect Block Index)
        LOGICAL_MAXIMUM(1), 0x7f,       //     LOGICAL_MAXIMUM (127)
        REPORT_SIZE(1), 0x07,           //     REPORT_SIZE (7)
        INPUT(1), 0x02,                 //     INPUT (Data,Var,Abs)
        USAGE(1), 0x24,                 //     USAGE (ROM Flag)
        LOGICAL_MAXIMUM(1), 0x01,       //     LOGICAL_MAXIMUM (1)
        REPORT_SIZE(1), 0x01,           //     REPORT_SIZE (1)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        INPUT(1), 0x02,                 //     INPUT (Data,Var,Abs)
        USAGE(1), 0x94,                 //     USAGE (Effect Playing)
        USAGE(1), 0xa0,                 //     USAGE (Actuators Enabled)
        USAGE(1), 0xa4,                 //     USAGE (Safety Switch)
        USAGE(1), 0xa6,                 //     USAGE (Actuator Power)
        REPORT_COUNT(1), 0x04,          //     REPORT_COUNT (4)
        INPUT(1), 0x02,                 //     INPUT (Data,Var,Abs)
        INPUT(1), 0x03,                 //     INPUT (Cnst,Var,Abs)
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x95,                 //   USAGE (PID Device Control Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x0b,             //     REPORT_ID (11)
        USAGE(1), 0x96,                 //     USAGE (PID Device Control)
        COLLECTION(1), 0x02,            //     COLLECTION (Logical)
        USAGE(1), 0x97,                 //       USAGE (DC Enable Actuators)
        USAGE(1), 0x98,                 //       USAGE (DC Disable Actuators)
        USAGE(1), 0x99,                 //       USAGE (DC Stop All Effects)
        USAGE(1), 0x9a,                 //       USAGE (DC Device Reset)
        USAGE(1), 0x9b,                 //       USAGE (DC Device Pause)
        USAGE(1), 0x9c,                 //       USAGE (DC Device Continue)
        LOGICAL_MINIMUM(1), 0x01,       //       LOGICAL_MINIMUM (1)
        LOGICAL_MAXIMUM(1), 0x06,       //       LOGICAL_MAXIMUM (6)
        REPORT_SIZE(1), 0x01,           //       REPORT_SIZE (1)
        REPORT_COUNT(1), 0x04,          //       REPORT_COUNT (4)
        OUTPUT(1), 0x00,                //       OUTPUT (Data,Ary,Abs)
        END_COLLECTION(0),              //     END_COLLECTION
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x85,                 //   USAGE (PID Pool Move Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x0c,             //     REPORT_ID (12)
        USAGE(1), 0x86,                 //     USAGE (Move Source)
        USAGE(1), 0x87,                 //     USAGE (Move Destination)
        USAGE(1), 0x88,                 //     USAGE (Move Length)
        LOGICAL_MAXIMUM(2), 0xff, 0x7f, //     LOGICAL_MAXIMUM (32767)
        REPORT_SIZE(1), 0x01,           //     REPORT_SIZE (1)
        REPORT_COUNT(1), 0x04,          //     REPORT_COUNT (4)
        OUTPUT(1), 0x00,                //     OUTPUT (Data,Ary,Abs)
        END_COLLECTION(0),              //   END_COLLECTION
        USAGE(1), 0x7d,                 //   USAGE (Device Gain Report)
        COLLECTION(1), 0x02,            //   COLLECTION (Logical)
        REPORT_ID(1), 0x02,             //     REPORT_ID (2)
        USAGE(1), 0x7e,                 //     USAGE (Device Gain)
        LOGICAL_MAXIMUM(2), 0xff, 0x00, //     LOGICAL_MAXIMUM (255)
        REPORT_SIZE(1), 0x08,           //     REPORT_SIZE (8)
        REPORT_COUNT(1), 0x01,          //     REPORT_COUNT (1)
        FEATURE(1), 0x02,               //     FEATURE (Data,Var,Abs)
        END_COLLECTION(0),              //   END_COLLECTION
#endif
        END_COLLECTION(0)               // END_COLLECTION
    };

    reportLength = sizeof(reportDescriptor);
    return reportDescriptor;
}

bool USBPID::EPINT_OUT_callback() {
    uint32_t bytesRead = 0;
    uint8_t output[65];
    uint8_t rID;
    USBDevice::readEP(EPINT_OUT, output, &bytesRead, MAX_PID_REPORT_SIZE);

    // get the report ID
    rID = output[0]
    
    switch(rID)
        // Set Envelope Report
        case 1 : 
    // we take led[1] because led[0] is the report ID
    lock_status = led[1] & 0x07;

    // We activate the endpoint to be able to recceive data
    if (!readStart(EPINT_OUT, MAX_HID_REPORT_SIZE))
        return false;
    return true;
}