//Imported BMP183 as library

#include "mbed.h"
#include "BMP183.h"

//DigitalOut my_led(LED1);
DigitalOut ChipSelectBaro(D2);

Serial serial(SERIAL_TX, SERIAL_RX);
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK);

uint8_t status;

int main()
{
    Timer t;
    BMP183 baro(SPI_MOSI, SPI_MISO, SPI_SCK, D2);
    int time;
    bool go = false;

    serial.baud(115200);
 
    serial.printf("Communication ready!\n");
    serial.printf("Initiating Baro...\n");

    status = baro.getID();
    
    if(status != 0x55) {
        go = false;
        serial.printf("Communication to Baro failed...\n");
    } else {
        serial.printf("Baro OK!\n\r");
        go = true;
    }
    
    serial.printf("Getting calibration data...\n");
    baro.getCalibrationData();
    serial.printf("Done...\n\n");
    
    t.start();
    while(go) {
        // Read sensor
        t.reset();
        baro.read();
        time = t.read_ms();
        serial.printf("Time: %i\n", time);
        serial.printf("Temp.: %f\n", baro.Temperature);
        serial.printf("Pres.: %f\n", baro.Pressure);
        serial.printf("Alt.: %f\n", baro.Altitude);
    }
}
