#ifndef BMP183_H
#define BMP183_H

#include "mbed.h"

/*=========================================================================
    REGISTERS
    -----------------------------------------------------------------------*/

#define    BMP183_REGISTER_CAL_AC1            0xAA  // R   Calibration data (16 bits)
#define    BMP183_REGISTER_CAL_AC2            0xAC  // R   Calibration data (16 bits)
#define    BMP183_REGISTER_CAL_AC3            0xAE  // R   Calibration data (16 bits)
#define    BMP183_REGISTER_CAL_AC4            0xB0  // R   Calibration data (16 bits)
#define    BMP183_REGISTER_CAL_AC5            0xB2  // R   Calibration data (16 bits)
#define    BMP183_REGISTER_CAL_AC6            0xB4  // R   Calibration data (16 bits)
#define    BMP183_REGISTER_CAL_B1             0xB6  // R   Calibration data (16 bits)
#define    BMP183_REGISTER_CAL_B2             0xB8  // R   Calibration data (16 bits)
#define    BMP183_REGISTER_CAL_MB             0xBA  // R   Calibration data (16 bits)
#define    BMP183_REGISTER_CAL_MC             0xBC  // R   Calibration data (16 bits)
#define    BMP183_REGISTER_CAL_MD             0xBE  // R   Calibration data (16 bits)
#define    BMP183_REGISTER_CHIPID             0xD0
#define    BMP183_REGISTER_VERSION            0xD1
#define    BMP183_REGISTER_SOFTRESET          0xE0
#define    BMP183_REGISTER_CONTROL            0xF4
#define    BMP183_REGISTER_TEMPDATA           0xF6
#define    BMP183_REGISTER_PRESSUREDATA       0xF6
#define    BMP183_REGISTER_READTEMPCMD        0x2E
#define    BMP183_REGISTER_READPRESSURECMD    0x34

/*=========================================================================*/

/*=========================================================================
    MODE SETTINGS
    -----------------------------------------------------------------------*/

#define    BMP183_MODE_ULTRALOWPOWER           0
#define    BMP183_MODE_STANDARD                1
#define    BMP183_MODE_HIGHRES                 2
#define    BMP183_MODE_ULTRAHIGHRES            3

/*=========================================================================*/

class BMP183
{
public:
    BMP183(PinName MOSI, PinName MISO, PinName SCLK, PinName CS);

    uint8_t getID(void);
    void getCalibrationData(void);
    void read(void);
    float Temperature, Pressure, Altitude;

private:
    SPI spi;
    DigitalOut cs;

    short AC1, AC2, AC3, B1, B2, MB, MC, MD;
    unsigned short AC4, AC5, AC6;
    short oss;

    void readRegister(uint8_t reg, char *buffer, int length);
    void writeRegister(uint8_t reg, int data);
    void writeRegister(uint8_t reg, char *buffer, int length);

    void ChipSelect(void);
    void ChipDeselect(void);
};


#endif //  BMP183_H