#include "mbed.h"
#include "TextLCD.h"
#include "hcsr04.h"

PwmOut dreapta(PTA4);
PwmOut stanga(PTD3);
DigitalOut in1(PTA5);
DigitalOut in2(PTC8);
DigitalOut in3(PTD0);
DigitalOut in4(PTD2);
TextLCD lcd(PTE21,PTE20,PTB0,PTB1,PTB2,PTB3);
Serial device(PTE22, PTE23);
DigitalOut Spate(PTC2);
DigitalOut Fata1(PTC1);
DigitalOut Fata2(PTA1);
DigitalOut SemnalizareStanga(PTD1);
DigitalOut SemnalizareDreapta(PTA2);

void setare_PWM_motoare(double Stanga,double Dreapta)
{
    stanga.period(0.020); 
    dreapta.period(0.020); 
    stanga.pulsewidth(Stanga);
    dreapta.pulsewidth(Dreapta);
}

int main() {
    double S,D;
    char Instr;
    device.baud(9600);
         
    while(1)
    {
    
        if(device.readable())
        {
        
            lcd.cls();
            lcd.locate(0,0);
            Instr = device.getc();
            switch (Instr){
                case 48://viteza motoare
                    lcd.cls();
                    lcd.locate(3,0);
                    lcd.printf("Viteza 0");
                    break;
                case 49://viteza motoare
                    lcd.cls();
                    lcd.locate(3,0);
                    lcd.printf("Viteza 1");
                    S=0.005;
                    D=0.005;
                    break;
                case 50://viteza motoare
                    lcd.cls();
                    lcd.locate(3,0);
                    lcd.printf("Viteza 2");
                    S=0.006;
                    D=0.006;
                    break;
                case 51://viteza motoare
                    lcd.cls();
                    lcd.locate(3,0);
                    lcd.printf("Viteza 3");
                    S=0.008;
                    D=0.008;
                    break;
                case 52://viteza motoare
                    lcd.cls();
                    lcd.locate(3,0);
                    lcd.printf("Viteza 4");
                    S=0.010;
                    D=0.010;
                    break;
                case 53://viteza motoare
                    lcd.cls();
                    lcd.locate(3,0);
                    lcd.printf("Viteza 5");
                    S=0.012;
                    D=0.012;
                    break;
                case 54://viteza motoare
                    lcd.cls();
                    lcd.locate(3,0);
                    lcd.printf("Viteza 6");
                    S=0.014;
                    D=0.014;
                    break;
                case 55://viteza motoare
                    lcd.cls();
                    lcd.locate(3,0);
                    lcd.printf("Viteza 7");
                    S=0.016;
                    D=0.016;
                    break;
                case 56://viteza motoare
                    lcd.cls();
                    lcd.locate(3,0);
                    lcd.printf("Viteza 8");
                    S=0.018;
                    D=0.018;
                    break;
                case 57://viteza motoare
                    lcd.cls();
                    lcd.locate(3,0);
                    lcd.printf("Viteza 9");
                    S=0.019;
                    D=0.019;
                    break; 
                case 87: //faruri fata ON
                    Fata1=1;
                    Fata2=1;
                    break;
                case 119://faruri fata OFF
                    Fata1=0;
                    Fata2=0;
                case 83://Stop
                    setare_PWM_motoare(0,0);
                    lcd.cls();
                    lcd.locate(5,0);
                    lcd.printf("Stop");
                    SemnalizareStanga=0;
                    SemnalizareDreapta=0;
                    Spate=1;
                    wait(0.02);
                    Spate=0;
                    break;
                case 70://inainte
                    lcd.cls();
                    lcd.locate(5,0);
                    lcd.printf("Inainte");
                    in1=0;
                    in2=1;
                    in3=1;
                    in4=0;
                    setare_PWM_motoare(S,D);
                    Spate=0;
                    SemnalizareStanga=0;
                    SemnalizareDreapta=0;
                break;
                case 66://inapoi
                    lcd.cls();
                    lcd.locate(5,0);
                    lcd.printf("Inapoi");
                    in1=1;
                    in2=0;
                    in3=0;
                    in4=1;
                    setare_PWM_motoare(S,D);
                    Spate=1;
                    SemnalizareStanga=0;
                    SemnalizareDreapta=0;
                break;
                case 82://viraj dreapta
                    lcd.cls();
                    lcd.locate(5,0);
                    lcd.printf("Dreapta");
                    setare_PWM_motoare(S,0);
                    SemnalizareStanga=0;
                    SemnalizareDreapta=1;
                    wait(0.04);
                    SemnalizareDreapta=0;
                break;
                case 76://viraj stanga
                    lcd.cls();
                    lcd.locate(5,0);
                    lcd.printf("Stanga");
                    setare_PWM_motoare(0,D);
                    SemnalizareStanga=1;
                    SemnalizareDreapta=0;
                    wait(0.04);
                    SemnalizareStanga=0;
                break;
                case 73://inainte->dreapta
                    lcd.cls();
                    lcd.locate(5,0);
                    lcd.printf("Inainte");
                    lcd.locate(5,1);
                    lcd.printf("Dreapta");
                    in1=0;
                    in2=1;
                    in3=1;
                    in4=0;
                    setare_PWM_motoare(S,D-0.005);
                    SemnalizareStanga=0;
                    SemnalizareDreapta=1;
                    wait(0.04);
                    SemnalizareDreapta=0;
                break;
                case 71://inainte->stanga
                    lcd.cls();
                    lcd.locate(5,0);
                    lcd.printf("Inainte");
                    lcd.locate(5,1);
                    lcd.printf("Stanga");
                    in1=0;
                    in2=1;
                    in3=1;
                    in4=0;
                    setare_PWM_motoare(S-0.005,D);
                    SemnalizareStanga=1;
                    SemnalizareDreapta=0;
                    wait(0.04);
                    SemnalizareStanga=0;
                break;
                case 72://inapoi->stanga
                    lcd.cls();
                    lcd.locate(5,0);
                    lcd.printf("Inapoi");
                    lcd.locate(5,1);
                    lcd.printf("Stanga");
                    in1=1;
                    in2=0;
                    in3=0;
                    in4=1;
                    setare_PWM_motoare(S-0.005,D);
                    SemnalizareStanga=1;
                    SemnalizareDreapta=0;
                    wait(0.04);
                    SemnalizareStanga=0;
                break;
                case 74://inapoi->dreapta
                    lcd.cls();
                    lcd.locate(5,0);
                    lcd.printf("Inapoi");
                    lcd.locate(5,1);
                    lcd.printf("Dreapta");
                    in1=1;
                    in2=0;
                    in3=0;
                    in4=1;
                    setare_PWM_motoare(S,D-0.005);
                    SemnalizareStanga=0;
                    SemnalizareDreapta=1;
                    wait(0.04);
                    SemnalizareDreapta=0;
                break;
            }
        }
    }
}
