#include "model.h"
#define TIME_OPEN_DOOR 3
#define TIME_GO 4
Model::Model(Serial *pci):communication(pci)
{

    cmd= new Commands();
    cmd->MotorDown[0]=0x2;
    cmd->MotorDown[1]=0xff;
    cmd->MotorDown[2]=0xff;
    cmd->MotorDown[3]=0xff;
    cmd->MotorDown[4]=0xfb;
    cmd->MotorUp[0]=0x2;
    cmd->MotorUp[1]=0x00;
    cmd->MotorUp[2]=0x00;
    cmd->MotorUp[3]=0x00;
    cmd->MotorUp[4]=0x14;
    cmd->MotorStop[0]=0x1;
    cmd->Lock[0]=0x00;
    cmd->LedOn[0]=0x01;
    cmd->LedOff[0]=0x00;
    cmd->ArrowDown[0]=0x02;
    cmd->ArrowUp[0]=0x01;
    direction=0;
    p4=1;
    p3=1;
    p2=1;
    p1=1;
    p0=1;

    NVIC_SetPriority(LPTimer_IRQn, 255);
}

void Model::doSomething()
{
    switch(getSourceAdd()) {
        case 0xe4:
            p4=1;
            poschodie=4;
            cmd->ArrowDown[1]=0x34;
            cmd->ArrowUp[1]=0x34;
            switch(direction) {
                case -1:
                    sendPacket(0xa0,0x30,0x00,cmd->ArrowDown,2);
                    break;
                case 1:
                    sendPacket(0xa0,0x30,0x00,cmd->ArrowUp,2);
                    break;
                default:
                    ;
            }
            if( mapPoschodie.find("p4")->second==true) {
                mapPoschodie.find("p4")->second=false;
                sendPacket(0xa0,0x24,0x00,cmd->LedOff,1);
                sendPacket(0xa0,0x14,0x00,cmd->LedOff,1);
                stopMotor();
                tmOut.attach(this,&Model::TimeOutCallBack,TIME_GO);
                tmOut2.attach(this,&Model::DoorUnlock,TIME_OPEN_DOOR);
            };
            break;
        case 0xe3:
            p3=1;
            poschodie=3;
            cmd->ArrowDown[1]=0x33;
            cmd->ArrowUp[1]=0x33;
            switch(direction) {
                case -1:
                    sendPacket(0xa0,0x30,0x00,cmd->ArrowDown,2);
                    break;
                case 1:
                    sendPacket(0xa0,0x30,0x00,cmd->ArrowUp,2);
                    break;
                default:
                    ;
            }
            if( mapPoschodie.find("p3")->second==true) {
                mapPoschodie.find("p3")->second=false;
                sendPacket(0xa0,0x13,0x00,cmd->LedOff,1);
                sendPacket(0xa0,0x23,0x00,cmd->LedOff,1);
                stopMotor();
                tmOut.attach(this,&Model::TimeOutCallBack,TIME_GO);
                tmOut2.attach(this,&Model::DoorUnlock,TIME_OPEN_DOOR);
            }
            break;
        case 0xe2:
            poschodie=2;
            p2=1;
            cmd->ArrowDown[1]=0x32;
            cmd->ArrowUp[1]=0x32;
            switch(direction) {
                case -1:
                    sendPacket(0xa0,0x30,0x00,cmd->ArrowDown,2);
                    break;
                case 1:
                    sendPacket(0xa0,0x30,0x00,cmd->ArrowUp,2);
                    break;
                default:
                    ;

            }
            if( mapPoschodie.find("p2")->second==true) {
                mapPoschodie.find("p2")->second=false;
                sendPacket(0xa0,0x12,0x00,cmd->LedOff,1);
                sendPacket(0xa0,0x22,0x00,cmd->LedOff,1);
                stopMotor();
                tmOut.attach(this,&Model::TimeOutCallBack,TIME_GO);
                tmOut2.attach(this,&Model::DoorUnlock,TIME_OPEN_DOOR);

            }
            break;
        case 0xe1:
            poschodie=1;
            cmd->ArrowDown[1]=0x31;
            cmd->ArrowUp[1]=0x31;
            p1=1;
            switch(direction) {
                case -1:
                    sendPacket(0xa0,0x30,0x00,cmd->ArrowDown,2);
                    break;
                case 1:
                    sendPacket(0xa0,0x30,0x00,cmd->ArrowUp,2);
                    break;
                default:
                    ;
            }
            if( mapPoschodie.find("p1")->second==true) {
                mapPoschodie.find("p1")->second=false;
                sendPacket(0xa0,0x11,0x00,cmd->LedOff,1);
                sendPacket(0xa0,0x21,0x00,cmd->LedOff,1);
                stopMotor();
                tmOut.attach(this,&Model::TimeOutCallBack,TIME_GO);
                tmOut2.attach(this,&Model::DoorUnlock,TIME_OPEN_DOOR);
            }
            break;

        case 0xe0:
            poschodie=0;
            p0=1;
            cmd->ArrowDown[1]=0x50;
            cmd->ArrowUp[1]=0x50;
            switch(direction) {
                case -1:
                    sendPacket(0xa0,0x30,0x00,cmd->ArrowDown,2);
                    break;
                case 1:
                    sendPacket(0xa0,0x30,0x00,cmd->ArrowUp,2);
                    break;
                default:
                    ;
            }
            if( mapPoschodie.find("p0")->second==true) {
                mapPoschodie.find("p0")->second=false;
                sendPacket(0xa0,0x10,0x00,cmd->LedOff,1);
                sendPacket(0xa0,0x20,0x00,cmd->LedOff,1);
                stopMotor();
                tmOut.attach(this,&Model::TimeOutCallBack,TIME_GO);
                tmOut2.attach(this,&Model::DoorUnlock,TIME_OPEN_DOOR);
            }
            break;
        default:
            ;
    }
    if( mapPoschodie.find("p4")->second==true&&p4==true) {
        p4=false;
        sendPacket(0xa0,0x14,0x00,cmd->LedOn,1);
        sendPacket(0xa0,0x24,0x00,cmd->LedOn,1);
        if(direction==0) { //chod nahor
            if(poschodie<4)
                upMotor();

        }
    } else if( mapPoschodie.find("p3")->second==true&&p3==true) {
        p3=false;
        sendPacket(0xa0,0x13,0x00,cmd->LedOn,1);
        sendPacket(0xa0,0x23,0x00,cmd->LedOn,1);
        if(direction==0) {
            if(poschodie<3)
                upMotor();
            else
                downMotor();

        }
    } else if( mapPoschodie.find("p2")->second==true&&p2==true) {
        p2=false;
        sendPacket(0xa0,0x12,0x00,cmd->LedOn,1);
        sendPacket(0xa0,0x22,0x00,cmd->LedOn,1);
        if(direction==0) {
            if(poschodie<2)
                upMotor();
            else
                downMotor();

        }
    } else if( mapPoschodie.find("p1")->second==true&&p1==true) {
        p1=false;
        sendPacket(0xa0,0x11,0x00,cmd->LedOn,1);
        sendPacket(0xa0,0x21,0x00,cmd->LedOn,1);
        if(direction==0) {
            if(poschodie<1)
                upMotor();
            else
                downMotor();

        }
    } else if( mapPoschodie.find("p0")->second==true&&p0==1) {
        p0=0;
        sendPacket(0xa0,0x10,0x00,cmd->LedOn,1);
        sendPacket(0xa0,0x20,0x00,cmd->LedOn,1);
        if(direction==0)
            downMotor();
    }
}
void Model::setDoorStatus(bool mValue)
{
    if(mValue==true)
        cmd->Lock[0]=0x01;//Lock door
    else
        cmd->Lock[0]=0x00;//;Unlock door

    sendPacket(0xa0,0xf0,0x0, cmd->Lock,1);
}
void Model::DoorUnlock()
{
    cmd->Lock[0]=0x00;//;Unlock door
    sendPacket(0xa0,0xf0,0x0, cmd->Lock,1);
}
void Model::stopMotor()
{
    direction=0;
    sendPacket(0xa0,0xf1,0x00,cmd->MotorStop,1);


}
void Model::downMotor()
{
    direction=-1;
    sendPacket(0xa0,0xf1,0x00,cmd->MotorDown,5);
    setDoorStatus(1);
}
void Model::upMotor()
{
    direction=1;
    sendPacket(0xa0,0xf1,0x00,cmd->MotorUp,5);
    setDoorStatus(1);
}
void Model::TimeOutCallBack()
{
    switch(poschodie) {
        case 4:
            if(mapPoschodie.find("p3")->second==true||mapPoschodie.find("p2")->second==true||mapPoschodie.find("p1")->second==true||mapPoschodie.find("p0")->second==true) {
                downMotor();
            }
            break;
        case 3:
            if(mapPoschodie.find("p2")->second==true||mapPoschodie.find("p1")->second==true||mapPoschodie.find("p0")->second==true) {
                downMotor();
            } else if(mapPoschodie.find("p4")->second==true) {
                upMotor();
            }
            break;
        case 2:
            if(mapPoschodie.find("p1")->second==true||mapPoschodie.find("p0")->second==true) {
                downMotor();
            } else if(mapPoschodie.find("p3")->second==true||mapPoschodie.find("p4")->second==true) {
                upMotor();
            }
            break;
        case 1:
            if(mapPoschodie.find("p0")->second==true) {
                downMotor();
            } else if(mapPoschodie.find("p2")->second==true||mapPoschodie.find("p3")->second==true||mapPoschodie.find("p4")->second==true) {
                upMotor();
            }
            break;
        case 0:
            if(mapPoschodie.find("p1")->second==true||mapPoschodie.find("p2")->second==true||mapPoschodie.find("p3")->second==true||mapPoschodie.find("p4")->second==true) {
                upMotor();
            }
            break;
        default:
            ;
    }

}

