#ifndef COMMUNICATION_H
#define COMMUNICATION_H
#include "mbed.h"
#include <map>
#include <iostream>

/**
*Trieda pouzita na komunikaciu vytahu
*/
class communication
{
public:
    /**Konstruktor , ako parameter si predavam Serial*/
    communication(Serial *_pc);

protected:
    /**Funkcia na odosielane znakov cez serial
    *@param startByte zatial vzdy 0xa0
    *@param target adresa prijmaca
    *@param source adresa odosielatela
    *@param data pole charov , data ktore chcem odoslat
    *@param DataSize - velkost data
    */
    void sendPacket(char startByte,char target,char source,char *data,int DataSize);
    /**Mapa na ukladanie stlacenie tlacidla na danom poschodi*/
    map<string, bool> mapPoschodie;

    int pom ;
    int poschodie ;
    char getSourceAdd() {
        return sourceAdd;
    }
private :
 /**
    *Funkcia na vypocet CRC8
    *@param targetAddr adresa prijmaca
    *@param senderAddr adresa odosielatela
    *@param data pole charov , data ktore chcem odoslat
    *@param DataSize - velkost data
    */
    char crcCalc(char targetAddr, char senderAddr, char *data,int DataSize);
    /**
    *Funkcia volavana vzdy pri preruseni akcelerometra(double tap)*/
    void tapTrue(void);
    /**
    *Funkcia volana pri prijatom znaku zo serialu 
    */
    void SerialCallBack();
    char startByteIn;
    char targetAdd;
    char sourceAdd;
    char DataLength;
    char *DataIn;
    char CrcIn;
    bool sendDataOk;
    static unsigned char crcArray[] ;
    Ticker tc;
    void TickerCallBack();
    char watchDog[1];
    char breakEm[1];
    DigitalOut cervena;
    DigitalOut zelena;
    Serial *pc;

};
#endif