#include "communication.h"
#include "mbed.h"
//DigitalOut cervena(LED1);
//DigitalOut zelena(LED2);
#include "MMA8451Q.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define ON  0
#define OFF !ON
//Setup the interrupts for the MMA8451Q
InterruptIn accInt1(PTA14);
InterruptIn accInt2(PTA15);//not used in this prog but this is the other int from the accelorometer
uint8_t togstat=0;//Led status
DigitalOut bled(LED_BLUE);
communication::communication(Serial *_pc):zelena(LED2),cervena(LED1)
{
    pc=_pc;
    pom =0;
    sourceAdd=0x05;
    pc->baud(57600);
    tc.attach(this,&communication::TickerCallBack,1);
    pc->attach(this,&communication::SerialCallBack,Serial::RxIrq);
    DataIn= new char[6]();
    mapPoschodie.insert(pair<string, bool>("p1",false));
    mapPoschodie.insert(pair<string, bool>("p2",false));
    mapPoschodie.insert(pair<string, bool>("p3",false));
    mapPoschodie.insert(pair<string, bool>("p4",false));
    mapPoschodie.insert(pair<string, bool>("p0",false));
    sendDataOk=false;
    poschodie=4;
    watchDog[0]=0x01;
    sendPacket(0xa0,0xfe,0x0, watchDog,1);
    watchDog[0]=0x02;
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    acc.setDoubleTap();
    accInt1.rise(this,&communication::tapTrue);
}
void communication::tapTrue(void)
{
    if(togstat == 0) {
        breakEm[0]=0x01;
        sendPacket(0xa0,0xf,0x00,breakEm,1);
        togstat = 1;
        bled=ON;
    } else if(togstat==1) {
        breakEm[0]=0x00;
        /*deaktivacia brzdy*/
        sendPacket(0xa0,0xf,0x00,breakEm,1);
        togstat = 2;
        bled=OFF;
    } else {
        togstat=0;
        watchDog[0]=0x01;
        sendPacket(0xa0,0xfe,0x00,watchDog,1);
        bled=ON;
    }
}

unsigned char communication::crcArray[]= {
    0, 94, 188, 226, 97, 63, 221, 131, 194, 156, 126, 32, 163, 253, 31, 65,
    157, 195, 33, 127, 252, 162, 64, 30, 95, 1, 227, 189, 62, 96, 130, 220,
    35, 125, 159, 193, 66, 28, 254, 160, 225, 191, 93, 3, 128, 222, 60, 98,
    190, 224, 2, 92, 223, 129, 99, 61, 124, 34, 192, 158, 29, 67, 161, 255,
    70, 24, 250, 164, 39, 121, 155, 197, 132, 218, 56, 102, 229, 187, 89, 7,
    219, 133, 103, 57, 186, 228, 6, 88, 25, 71, 165, 251, 120, 38, 196, 154,
    101, 59, 217, 135, 4, 90, 184, 230, 167, 249, 27, 69, 198, 152, 122, 36,
    248, 166, 68, 26, 153, 199, 37, 123, 58, 100, 134, 216, 91, 5, 231, 185,
    140, 210, 48, 110, 237, 179, 81, 15, 78, 16, 242, 172, 47, 113, 147, 205,
    17, 79, 173, 243, 112, 46, 204, 146, 211, 141, 111, 49, 178, 236, 14, 80,
    175, 241, 19, 77, 206, 144, 114, 44, 109, 51, 209, 143, 12, 82, 176, 238,
    50, 108, 142, 208, 83, 13, 239, 177, 240, 174, 76, 18, 145, 207, 45, 115,
    202, 148, 118, 40, 171, 245, 23, 73, 8, 86, 180, 234, 105, 55, 213, 139,
    87, 9, 235, 181, 54, 104, 138, 212, 149, 203, 41, 119, 244, 170, 72, 22,
    233, 183, 85, 11, 136, 214, 52, 106, 43, 117, 151, 201, 74, 20, 246, 168,
    116, 42, 200, 150, 21, 75, 169, 247, 182, 232, 10, 84, 215, 137, 107, 53
};

char communication::crcCalc(char targetAddr, char senderAddr, char *data,int DataSize)
{
    int dataLenght = DataSize;
    char crc = 0x00;
    crc = crcArray[crc^targetAddr];
    crc = crcArray[crc^senderAddr];
    for(int i = 0 ; i < dataLenght ; i++) {
        crc = crcArray[crc^data[i]];
    }
    return crc;
}
void communication::sendPacket(char startByte,char target,char source,char *data,int DataSize)
{
    sendDataOk=true;
    int cnt=0;
    while(sendDataOk) {
        //packet format : || start byte: a0 | reciever adress - 1B | sender adress - 1B | data lenght - 1B | data - 0-265B | crc8 - 1B ||
        int dataLenght = DataSize;
        char crc8 = crcCalc(target, source, data,dataLenght);
        pc->putc(startByte);
        pc->putc(target);
        pc->putc(source);
        pc->putc(dataLenght);
        for (int i = 0 ; i < dataLenght ; i++) {
            pc->putc(data[i]);
        }
        pc->putc(crc8);
        wait(0.003);
    }
}
void communication::TickerCallBack()
{
    sendPacket(0xa0,0xfe,0x00, watchDog,1);
    pom++;
    if (pom==1) {
        zelena =0;
        cervena=1;
    } else {
        zelena=1;
        cervena=0;
        pom=0;
    }
}
void communication::SerialCallBack()
{

    startByteIn=pc->getc();
    targetAdd=pc->getc();
    sourceAdd=pc->getc();
    DataLength=pc->getc();
    for (unsigned int i=0; i< DataLength; i++) {
        DataIn[i]=pc->getc();
    }
    CrcIn=pc->getc();
    switch( sourceAdd) {
        case 0xc4:
        case 0xb4:
            if(poschodie!=4)
                mapPoschodie.find("p4")->second=true;
            break;
        case 0xb3:
        case 0xc3:
            if(poschodie!=3)
                mapPoschodie.find("p3")->second=true;
            break;
        case 0xb2:
        case 0xc2:
            if(poschodie!=2)
                mapPoschodie.find("p2")->second=true;
            break;
        case 0xb1:
        case 0xc1:
            if(poschodie!=1)
                mapPoschodie.find("p1")->second=true;
            break;
        case 0xb0:
        case 0xc0:
            if(poschodie!=0)
                mapPoschodie.find("p0")->second=true;
            break;
        default:
            ;
    }
    //osetrenie ACK
    if(sourceAdd==0x00)
        sendDataOk=false;
}

