#include "mbed.h"
#include "headre.h"
#include "FreeFall.h"

Serial pc(USBTX, USBRX, 57600);

int i;
unsigned int velkost;
char crc=0x00;

DigitalOut myled(LED3);
DigitalOut myled2(LED2);

char prijemSpravy[30];
char diode_DATA[]={0x00,0x01};
int diode_cislo[]={0,0,0,0,0};
int stav=5;
int poradie[]={0,0,0,0,0};

char buffer_kto[100];
char buffer_co[100];
int buff_index=0;
int cyklus=0;

int main()
{
    pc.attach(&prijmemSpravu);
    init_freeFall();
    
    while(true)
    {
        rozhodni();
        if(freeFall_status())
            {
                zamkni();
                stop();
                myled=1;
                myled2=1;
                break;
            }
    }   
}

void pohyb(int kam)
{
    zamkni();
    if (stav <kam) {hore();vytahDisplay(1,kam);}
    if (stav >kam) {dole();vytahDisplay(2,kam);}

}

void prijmemSpravu()
{
    myled=0; 

    for (int j=0;j<4;j++)
    {
        while(true)
        {
            if(pc.readable()==1)
            {
                prijemSpravy[j]=pc.getc(); 
                break;                                 
            }
        }    
    }
    
    int pom= prijemSpravy[3] + 1;
    
    for (int j=0;j<pom;j++)
    {
        while(true)
        {
            if(pc.readable()==1)
            {
                prijemSpravy[j+4]=pc.getc();
                break;                                  
            }
        }    
    }
    buffer_kto[buff_index]=prijemSpravy[2];
    buffer_co[buff_index]=prijemSpravy[4];
       
    myled=1; 
    pc.attach(&prijmemSpravu);
}

void rozhodni()
{ 
    myled2=0; 
    char bData=buffer_co[cyklus];
    switch(buffer_kto[cyklus])
    {
        case 0xb4: /* vytah tla4idlo 4 poschodie   */
            poslemSpravu(VYTAH_DIODA_4,0xCC,0x01, &diode_DATA[1]);
            diode_cislo[4]=1; 
            pohyb(4);
        break;
        
        case 0xb3: /* vytah tla4idlo 3 poschodie   */
            poslemSpravu(VYTAH_DIODA_3,0xCC,0x01, &diode_DATA[1]);
            diode_cislo[3]=1;
            pohyb(3);
        break;
        
        case 0xb2: /* vytah tla4idlo 2 poschodie   */
            poslemSpravu(VYTAH_DIODA_2,0xCC,0x01, &diode_DATA[1]);
            diode_cislo[2]=1;
            pohyb(2);
        break;
        
        case 0xb1: /* vytah tla4idlo 1 poschodie   */
            poslemSpravu(VYTAH_DIODA_1,0xCC,0x01, &diode_DATA[1]);
            diode_cislo[1]=1;
            pohyb(1);
        break;
        
        case 0xb0: /* vytah tla4idlo pr9zemie   */
            poslemSpravu(VYTAH_DIODA_P,0xCC,0x01, &diode_DATA[1]);
            diode_cislo[0]=1;
            pohyb(0);
        break;
        
        case 0xc4: /* chodba tla4idlo 4 poschodie   */
            poslemSpravu(POSCHODIE_DIODA_4,0xCC,0x01, &diode_DATA[1]);
            diode_cislo[4]=1;
            pohyb(4);
        break;
        
        case 0xc3: /* chodba tla4idlo 3 poschodie   */
            poslemSpravu(POSCHODIE_DIODA_3,0xCC,0x01, &diode_DATA[1]);
            diode_cislo[3]=1;
            pohyb(3);
        break;
        
        case 0xc2: /* chodba tla4idlo 2 poschodie   */
            poslemSpravu(POSCHODIE_DIODA_2,0xCC,0x01, &diode_DATA[1]);
            diode_cislo[2]=1;
            pohyb(2);
        break;
        
        case 0xc1: /* chodba tla4idlo 1 poschodie   */
            poslemSpravu(POSCHODIE_DIODA_1,0xCC,0x01, &diode_DATA[1]);
            diode_cislo[1]=1;
            pohyb(1);
        break;
        
        case 0xc0: /* chodba tla4idlo pr9zemie   */
            poslemSpravu(POSCHODIE_DIODA_P,0xCC,0x01, &diode_DATA[1]);
            diode_cislo[0]=1;
            pohyb(0);
        break;
        
        
        
        
        case 0xe4: /* info pre odomknutie 4 poschodie   */
            if(bData==0x01&&diode_cislo[4]==1)
            {   
                stop();
                poslemSpravu(VYTAH_DIODA_4,0xCC,0x01, &diode_DATA[0]);
                poslemSpravu(POSCHODIE_DIODA_4,0xCC,0x01, &diode_DATA[0]);
                diode_cislo[4]=0;
                stav=4;
            }
            
            if(bData==0x02&&stav==4)
            {
                wait(1);
                odomkni();
            
                if (diode_cislo[3]==1) pohyb(0);
                else if (diode_cislo[2]==1) pohyb(1);
                else if (diode_cislo[1]==1) pohyb(2);
                else if (diode_cislo[0]==1) pohyb(3);
            }
        break;
        
        case 0xe3: /* info pre odomknutie 3 poschodie   */
            if(bData==0x01&&diode_cislo[3]==1)
            {
                stop();
                poslemSpravu(VYTAH_DIODA_3,0xCC,0x01, &diode_DATA[0]);
                poslemSpravu(POSCHODIE_DIODA_3,0xCC,0x01, &diode_DATA[0]);
                diode_cislo[3]=0;
                stav=3;
            }
            
            if(bData==0x02&&stav==3)
            {
                wait(1);
                odomkni();

                if (diode_cislo[4]==1) pohyb(0);
                else if (diode_cislo[2]==1) pohyb(1);
                else if (diode_cislo[1]==1) pohyb(2);
                else if (diode_cislo[0]==1) pohyb(4);
            }
        break;
        
        case 0xe2: /* info pre odomknutie 2 poschodie   */
            if(bData==0x01&&diode_cislo[2]==1)
            {
                stop();
                poslemSpravu(VYTAH_DIODA_2,0xCC,0x01, &diode_DATA[0]);
                poslemSpravu(POSCHODIE_DIODA_2,0xCC,0x01, &diode_DATA[0]);
                diode_cislo[2]=0;
                stav=2;
            }
            
            if(bData==0x02&&stav==2)
            {
                wait(1);
                odomkni();
        
                if (diode_cislo[0]==1) pohyb(0);
                else if (diode_cislo[1]==1) pohyb(1);
                else if (diode_cislo[3]==1) pohyb(3);
                else if (diode_cislo[4]==1) pohyb(4);
                }
        break;
        
        case 0xe1: /* info pre odomknutie 1 poschodie   */
            if(bData==0x01&&diode_cislo[1]==1)
            {
                stop();
                poslemSpravu(VYTAH_DIODA_1,0xCC,0x01, &diode_DATA[0]);
                poslemSpravu(POSCHODIE_DIODA_1,0xCC,0x01, &diode_DATA[0]);
                diode_cislo[1]=0;
                stav=1;
            }
            
            if(bData==0x02&&stav==1)
            {
                wait(1);
                odomkni();
        
                if (diode_cislo[0]==1) pohyb(0);
                else if (diode_cislo[2]==1) pohyb(2);
                else if (diode_cislo[3]==1) pohyb(3);
                else if (diode_cislo[4]==1) pohyb(4);
            }

        break;
        
        case 0xe0: /* info pre odomknutie prízemie   */
            if(bData==0x01&&diode_cislo[0]==1)
            {
                stop();
                poslemSpravu(VYTAH_DIODA_P,0xCC,0x01, &diode_DATA[0]);
                poslemSpravu(POSCHODIE_DIODA_P,0xCC,0x01, &diode_DATA[0]);
                diode_cislo[0]=0;
                stav=0;
            }
            
            if(bData==0x02&&stav==0)
            {
                wait(1);
                odomkni();
                
                if (diode_cislo[1]==1) pohyb(1);
                else if (diode_cislo[2]==1) pohyb(2);
                else if (diode_cislo[3]==1) pohyb(3);
                else if (diode_cislo[4]==1) pohyb(4);}
        break;

        default: break;
    }  
 
    myled=1; 
}

void poslemSpravu(char adrRX, char adrTX, int velkost, char DATA[] )
{
    crc=0x00;
    char odosli[5+velkost];
    odosli[0]=0xA0;
    odosli[1]=adrRX;
    odosli[2]=adrTX;
    odosli[3]=velkost;

    crc=crc8table[crc^adrRX];
    crc=crc8table[crc^adrTX];

    for (i=0; i<velkost; i++) 
    {
        odosli[4+i]=DATA[i];
    }

    for (i=0; i<velkost; i++) 
    {
        crc=crc8table[crc^DATA[i]];
    }

    odosli[velkost+4]=crc;

    for (i=0; i<velkost+5; i++) 
    {
        pc.putc(odosli[i]);
    }

}

