#ifndef HEADRE_H
#define HEADRE_H




/** Headre
 *  Hlavičkový súbor s definíciami konštánt a funkcii výťahu.
 */
class Headre {
    public:
       
        /**
        * Funkcia na poslanie správy simulátoru
        *
        * @param adrRX adresa RX
        * @param adrTX adresa TX
        * @param velkost velkost správy
        * @param DATA[] pole dát
        */        
        void poslemSpravu(char adrRX, char adrTX, int velkost, char DATA[] );
        
        /** Funkcia na prijatie správy */
        void prijmemSpravu();

        /** Case kde sa vyhodnoti aká správa bola prijatá a následne sa vykoná akcia na správu */
        void rozhodni();
        
        /**
         * Funkcia na pohyb kabíny
         * @param kam udáva smer kma sa kabína pohne hore alebo dole
         */
        void pohyb(int kam);
        
        /** Funkcia na zamknutie kabíny */
        void zamkni();
        
        /** Funkcia na odomknutie kabíny */
        void odomkni();
        
        /** Funkcia na vypnutie motora a zastavenie pohybu kabíny */
        void stop();
        
        /** Funkcia na zapnutie motora a pohyb kabíny smerom hore */
        void hore();
        
        /** Funkcia na zapnutie motora a pohyb kabíny smerom dole */
        void dole();

        /** 
         * Funkcia na ovládanie informačného displeju v kabíne 
         *
         * @param smer smerom sa udáva či pojde kabína hore alebo dole
         * @param poschodie poschodie ukáže ktoré poschodie bolo stlačené a kam pôjde
         */
        void vytahDisplay(int smer, int poschodie);     
        
};





#define DISPLAY     0x30    // DATA smer  0x01-> UP 0x02-> DOWN , text (string)
#define TERMINAL    0xD0    // Vypise vsetko

#define VYTAH_BUTTON_P  0xb0        // ┌-----------┐
#define VYTAH_BUTTON_1  0xb1        // | DATA 0xFF |
#define VYTAH_BUTTON_2  0xb2        // |-----------|
#define VYTAH_BUTTON_3  0xb3        // |-----------|
#define VYTAH_BUTTON_4  0xb4        // |-----------|

#define POSCHODIE_BUTTON_P  0xc0    // |-----------|
#define POSCHODIE_BUTTON_1  0xc1    // |-----------|
#define POSCHODIE_BUTTON_2  0xc2    // |-----------|
#define POSCHODIE_BUTTON_3  0xc3    // |-----------|
#define POSCHODIE_BUTTON_4  0xc4    // └-----------┘

#define VYTAH_DIODA_P   0x20        // ┌--------------------------┐ 
#define VYTAH_DIODA_1   0x21        // | DATA 0x00-> OFF 0x01->ON |
#define VYTAH_DIODA_2   0x22        // |--------------------------|
#define VYTAH_DIODA_3   0x23        // |--------------------------|
#define VYTAH_DIODA_4   0x24        // |--------------------------|

#define POSCHODIE_DIODA_P   0x10    // |--------------------------|
#define POSCHODIE_DIODA_1   0x11    // |--------------------------|
#define POSCHODIE_DIODA_2   0x12    // |--------------------------|
#define POSCHODIE_DIODA_3   0x13    // |--------------------------|
#define POSCHODIE_DIODA_4   0x14    // └--------------------------┘

#define VYTAH   0xf0    // DATA 0x00-> UNLOCK  0x01-> LOCK
#define BRZDA   0x0f     // DATA 0x00-> DEACTIVATE  0x01-> ACTIVATE

#define FLOOR_LIMIT_SWITCH_P    0xe0    // ┌------------------------------------------┐ 
#define FLOOR_LIMIT_SWITCH_1    0xe1    // | DATA 0x00-> LOW 0x01->WIDE 0x02-> NARROW |
#define FLOOR_LIMIT_SWITCH_2    0xe2    // |------------------------------------------|
#define FLOOR_LIMIT_SWITCH_3    0xe3    // |------------------------------------------|
#define FLOOR_LIMIT_SWITCH_4    0xe4    // └------------------------------------------┘

#define MOTOR   0xf1    // DATA 0x1-> STOP 0x02-> UP/DOWN 32bit <-100,100> 0x3-> MOTOR ENCODER COUNT (double)
#define WATCHDOG 0xfe   // DATA 0x01-> time out ELSE regular reset ( 1500ms )

const unsigned char crc8table[256] = {
    0, 94, 188, 226, 97, 63, 221, 131, 194, 156, 126, 32, 163, 253, 31, 65,
    157, 195, 33, 127, 252, 162, 64, 30, 95, 1, 227, 189, 62, 96, 130, 220,
    35, 125, 159, 193, 66, 28, 254, 160, 225, 191, 93, 3, 128, 222, 60, 98,
    190, 224, 2, 92, 223, 129, 99, 61, 124, 34, 192, 158, 29, 67, 161, 255,
    70, 24, 250, 164, 39, 121, 155, 197, 132, 218, 56, 102, 229, 187, 89, 7,
    219, 133, 103, 57, 186, 228, 6, 88, 25, 71, 165, 251, 120, 38, 196, 154,
    101, 59, 217, 135, 4, 90, 184, 230, 167, 249, 27, 69, 198, 152, 122, 36,
    248, 166, 68, 26, 153, 199, 37, 123, 58, 100, 134, 216, 91, 5, 231, 185,
    140, 210, 48, 110, 237, 179, 81, 15, 78, 16, 242, 172, 47, 113, 147, 205,
    17, 79, 173, 243, 112, 46, 204, 146, 211, 141, 111, 49, 178, 236, 14, 80,
    175, 241, 19, 77, 206, 144, 114, 44, 109, 51, 209, 143, 12, 82, 176, 238,
    50, 108, 142, 208, 83, 13, 239, 177, 240, 174, 76, 18, 145, 207, 45, 115,
    202, 148, 118, 40, 171, 245, 23, 73, 8, 86, 180, 234, 105, 55, 213, 139,
    87, 9, 235, 181, 54, 104, 138, 212, 149, 203, 41, 119, 244, 170, 72, 22,
    233, 183, 85, 11, 136, 214, 52, 106, 43, 117, 151, 201, 74, 20, 246, 168,
    116, 42, 200, 150, 21, 75, 169, 247, 182, 232, 10, 84, 215, 137, 107, 53
};

void poslemSpravu(char adrRX, char adrTX, int velkost, char DATA[] );
void prijmemSpravu();

void rozhodni();
void pohyb(int kam);

void zamkni();
void odomkni();

void stop();
void hore();
void dole();

void kontrola();
void vytahDisplay(int smer, int poschodie);

#endif