#include "FreeFall.h"
#include "headre.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

PinName const SDA = PTE25;
PinName const SCL = PTE24;

DigitalOut freeFall_LED(LED_RED);
InterruptIn acc(PTA15);
I2C i2c(SDA, SCL);

bool freeFall_check;

void freeFall()
{
    uint8_t IntSourceSystem = 0;
    char t[1] = {0x0C};
    i2c.write(MMA8451_I2C_ADDRESS , t, 1, true);
    i2c.read(MMA8451_I2C_ADDRESS , (char *)&IntSourceSystem, 1);

    if ((IntSourceSystem&0x04)==0x04) 
    {
         char DATA [] = {0x01};
         poslemSpravu(BRZDA, 0xcc, 0x01, DATA );
         freeFall_LED = 0;
         freeFall_check = 1;
    }
}


void init_freeFall()
{
    //https://www.nxp.com/docs/en/application-note/AN4070.pdf?&fasp=1&WT_TYPE=Applicatio
    uint8_t data1[2] = {0x2A, 0x20}; // Deaktivacia senzora
    i2c.write(MMA8451_I2C_ADDRESS , (char *)data1, 2);
    uint8_t data2[2] = {0x15, 0xB8};
    i2c.write(MMA8451_I2C_ADDRESS , (char *)data2, 2);
    uint8_t data3[2] = {0x17, 0x03};
    i2c.write(MMA8451_I2C_ADDRESS , (char *)data3, 2);
    uint8_t data4[2] = {0x18, 0x06};
    i2c.write(MMA8451_I2C_ADDRESS , (char *)data4, 2);
    uint8_t data5[2] = {0x2D, 0x04};
    i2c.write(MMA8451_I2C_ADDRESS , (char *)data5, 2);
    uint8_t data6[2] = {0x2E, 0x00};
    i2c.write(MMA8451_I2C_ADDRESS , (char *)data6, 2);
    uint8_t data7[2]= {0x2A, 0x09 }; //Frekvencia je nastavena na 400 Hz, aktivacia senzora
    i2c.write(MMA8451_I2C_ADDRESS , (char *)data7, 2);
    
    freeFall_check = false;
    freeFall_LED = 1;
    
    acc.fall(&freeFall);
}

bool freeFall_status()
{
    return freeFall_check;
}