#ifndef MBED_MORSE_H
#define MBED_MORSE_H

#include "mbed.h"

/**
 *  @file       morse.h
 *  Project     morse code handling Library
 *  @brief      morse code handling library for mbed
 *  @version    1.0
 *  @author     Chuck Timber
 *  @date       07/08/2014
 */
/**
 *  @file       morse.cpp
 *  Project     morse code handling Library
 *  @brief      morse code handling library for mbed
 *  @version    1.0
 *  @author     Chuck Timber
 *  @date       07/08/2014
 */
/** class to generate Morse code tone and keying signal.
 *         sound with a buzzer, based on a PwmOut, 
 *         keying signal base on a DigitalOut
 *
 * Example:
 * @code
 * // Morse sample
 * #include "mbed.h"
 * #include "morse.h"
 *
 * char* codes[] = { ".-", "-...", "-.-.", "-..", ".",
 *                   "..-.", "--.", "....", "..", ".---",
 *                   "-.-", ".-..", "--", "-.", "---",
 *                   ".--.", "--.-", ".-.", "...", "-",
 *                   "..-", "...-", ".--", "-..-", "-.--", "--..", " "
 *                 };
 *
 * Morse morse;
 * //Morse morse(dp24, LED1);
 * //Morse morse(dp24, LED1, 0.1, 800);
 * 
 * int main()
 * {
 *     int i;
 * 
 *     while(1) {
 *         for (i = 0; i < 27; i++) {
 *             morse.code(codes[i]);
 *         }
 *     }
 * }
 * @endcode
 */

namespace mbed {
/** Class: Morse
 *  A class whitch uses pwm and digitalout to generate morse tone and signal.
 */
class Morse {

private:
    /// morse speed conversion table
    static const float table[128];
    float cw_tick;
    int tick_idx;
    float freq;
    DigitalOut _pout;
    PwmOut _pwm;

    void beep (int k);
    void space(int k);


public:

    void setfreq(float f);
    float getfreq(void);
    void settick(float t);
    float gettick(void);
    void setidx(int idx);
    int getidx(void);
    void incidx(void);
    void decidx(void);

    void code(char* code);

    Morse(void);
    Morse(PinName pwm, PinName led);
    Morse(PinName pwm, PinName led, float t);
    Morse(PinName pwm, PinName led, float t, float f);

}; // end of class definition Morse
} // end of namespace mbed
#endif
