/**
 *  @file       button.h
 *  Project     button handling Library
 *  @brief      button handling library for mbed
 *  @version    1.03
 *  @author     Chuck Timber
 *  @date       12/08/2014
 */

#ifndef MBED_BUTTON_H
#define MBED_BUTTON_H

#include "mbed.h"

/** @defines
 */
#define BTN_SAMPLING_PERIOD 0.01

namespace mbed
{

/** Class: BTN
 *  A class handles button input procedure, which uses DigitalIn and Ticker
 *
 * Refered to: http://elm-chan.org/docs/tec/te03.html
 *
 * Example:
 * @code
 * // Button sample
 * #include "mbed.h"
 * #include "button.h"
 *
 * BTN btn(dp13);
 *
 * int main()
 * {
 *     int mode = 0;
 *     int value;
 *
 *     btn.CMD = 0;
 *     while(1) {
 *         if(btn.CMD) {
 *             mode++;
 *             btn.CMD = 0;
 *             srand( time(NULL) );
 *         }
 *         if (mode % 2) value = rand();
 *     }
 * }
 * @endcode
 */
class BTN
{

public:
    unsigned char CMD;   /*!< CMD represents that the button has been pressed.
                          *   @retval 1 - button has been pressed
                          */

    unsigned char STAT;  /*!< STAT represents that the button is being pressed.
                          *   @retval 1 - button is being pressed
                          */

    /** constructor
     *
     *  @param pin - button pin number (DigitalIn), the pin is PullUp internally
     */
    BTN(PinName pin);

    /// destructor
    virtual ~BTN() { };

private:
    /** sample_btn input and process */
    void sample_btn(void);
    unsigned char FIL;
    DigitalIn _Pin;
    Ticker _Tick;

};

}
#endif
