/**
 *  @file       button.cpp
 *  Project     button handling Library
 *  @brief      button handling library for mbed
 *  @version    1.03
 *  @author     Chuck Timber
 *  @date       12/08/2014
 */

#include "button.h"
#include "mbed.h"

/* class to handle button input 
 *   The class use DigitalIn and Ticker
 *
 */

using namespace mbed;

// private function
/** sample_btn input and process */
void BTN::sample_btn()
{
    unsigned char a, b;

    a = (_Pin) ? 0 : 1;
    
    if (a == FIL) {
        b = STAT;
        STAT = a;
        b = (b ^ a) & a;
        if (b) CMD = b;
    }
    FIL = a;
}

// constructor
/** Create a BTN object connected to a DigtalIn pin
 *
 * @param pin - DigitalIn pin connected to the switch 
 */
BTN::BTN(PinName pin) : _Pin(pin) {
    _Pin.mode(PullUp);
    CMD = STAT = FIL = 0;
    _Tick.attach(this, &BTN::sample_btn, BTN_SAMPLING_PERIOD);
}
