#ifndef MBED_BUTTON_H
#define MBED_BUTTON_H

#include "mbed.h"

/** class to handle button input 
 *   The class use DigitalIn and Ticker
 *
 * Refered to: http://elm-chan.org/docs/tec/te03.html
 *
 * Example:
 * @code
 * // Button sample
 * #include "mbed.h"
 * #include "button.h"
 * 
 * BTN btn(dp13);
 * 
 * int main()
 * {
 *     int mode = 0;
 *     int value;
 * 
 *     btn.CMD = 0;
 *     while(1) {
 *         if(btn.CMD) {
 *             mode++;
 *             btn.CMD = 0;
 *             srand( time(NULL) );
 *         }
 *         if (mode % 2) value = rand();
 *     }
 * }
 * @endcode
 */

#define BTN_SAMPLING_PERIOD 0.01

namespace mbed {

/* Class: BTN
 *  A class which uses DigitalIn and Ticker
 */
class BTN {

public:
    BTN(PinName pin);
    unsigned char CMD;
    unsigned char STAT;

private:
    void sample_btn(void);
    unsigned char FIL;
    DigitalIn _Pin;
    Ticker _Tick;

};

}
#endif
