#include "button.h"
#include "mbed.h"

/** class to handle button input 
 *   The class use DigitalIn and Ticker
 *
 * Example:
 * @code
 * // Button sample
 * #include "mbed.h"
 * #include "button.h"
 * 
 * BTN btn(dp13);
 * 
 * int main()
 * {
 *     int mode = 0;
 *     int value;
 * 
 *     btn.CMD = 0;
 *     while(1) {
 *         if(btn.CMD) {
 *             mode++;
 *             btn.CMD = 0;
 *             srand( time(NULL) );
 *         }
 *         if (mode % 2) value = rand();
 *     }
 * }
 * @endcode
 */

using namespace mbed;

// private function
/** sample_btn input and process
 *
 */
void BTN::sample_btn()
{
    unsigned char a, b;

    a = _Pin;
    
    if (a == FIL) {
        b = STAT;
        STAT = a;
        b = (b ^ a) & a;
        if (b) CMD = b;
    }
    FIL = a;
}

 // constructor
 /** Create a BTN object connected to a DigtalIn pin
  *
  * @param pin - DigitalIn pin connected to the switch 
  */
BTN::BTN(PinName pin) : _Pin(pin) {
    CMD = STAT = FIL = 0;
    _Tick.attach(this, &BTN::sample_btn, BTN_SAMPLING_PERIOD);
}
