#include "mbed.h"
#include "button.h"
#include "REnc.h"
#include "morse.h"
#include "MIDI.h"

// alphabet 26-charactor + 1-space
char* codes[] = { ".-", "-...", "-.-.", "-..", ".",
                  "..-.", "--.", "....", "..", ".---",
                  "-.-", ".-..", "--", "-.", "---",
                  ".--.", "--.-", ".-.", "...", "-",
                  "..-", "...-", ".--", "-..-", "-.--", "--..", " "
                };

// 10-number
char* nums[] = { "-----", ".----", "..---", "...--", "....-",
                 ".....", "-....", "--...", "---..", "----."
               };

// 15-marks
char* marks[] = { ".-.-.-",  // '.'
                  "--..--",  // ','
                  "..--..",  // '?'
                  "-.-.--",  // '!'
                  "-....-",  // '-'
                  "-..-.",   // '/'
                  ".--.-.",  // '@'
                  "-.--.",   // '('
                  "-.--.-",  // ')'
                  "-...-",   // '='
                  ".-..-.",  // '"'
                  ".-.-.",   // '+'
                  ".----.",  // '''
                  "---...",  // ':'
                  "........" // 'HH'
                };

// 6-hybrid
char* hybrid[] = { ".-...",   // 'AS'
                   ".-.-.",   // 'AR'
                   "-...-.-", // 'BK' 
                   "-...-",   // 'BT'
                   "-.--.",   // 'KN'
                   "...-.-"   // 'VA' 
                 };



void proc_NoteOn(byte channel, byte note, byte velocity);
void proc_ControlChange(byte channel, byte number, byte value);
void proc_REnc_right(void);
void proc_REnc_left(void);


BTN btn(dp13);
Morse morse;    // LED1, dp24
MIDI midi(dp16, dp15);
REnc renc(dp1, dp2);
DigitalOut isMidi(dp17);
DigitalOut isNotMidi(dp18);


int main()
{
    int i;
    int mode = 0;
    int value;

    //Morse morse(dp24, LED1);
    //Morse morse(dp24, LED1, 0.08, 1000);

    midi.setHandleNoteOn(&proc_NoteOn);
    midi.setHandleControlChange(&proc_ControlChange);
    
    renc.setHandleCC(&proc_REnc_right);
    renc.setHandleCCW(&proc_REnc_left);
 
    midi.begin();
    wait(1.0);
    btn.CMD = 0;

    while(1) {
        midi.read();
/*
        if (renc.CMD == CLOCKWISE) {
            morse.incidx();
            renc.CMD = STOP
        } else if (renc.CMD == COUNTERCLOCKWISE) {
            morse.decidx();
            renc.CMD = STOP;
        }
*/
        if(btn.CMD) {
            mode++;
            btn.CMD = 0;
            srand( time(NULL) );
        }
        if (mode % 2) {
            isNotMidi = 1;
            isMidi = 0;
            for (i = 0; i < 5; i++) {
                value = rand();
                morse.code(codes[value % 26]);
            }
            morse.code(codes[26]);
        } else {
            isNotMidi = 0;
            isMidi = 1;
        }
    }
}

void proc_NoteOn(byte channel, byte note, byte velocity)
{
    if ((36 <= note) && (note <= 36+26)) {
        morse.code(codes[note - 36]);
   }
}

void proc_ControlChange(byte channel, byte number, byte value)
{
    if (number == 16) { // General Purpose Controller 1
        morse.setidx(value);
    }    
}

void proc_REnc_right(void)
{
    morse.incidx();
}

void proc_REnc_left(void)
{
    morse.decidx();
}
