/**
 *  @file       btn2.h
 *  Project     button long press handling sample
 *  @brief      button long press handling class
 *  @version    1.00
 *  @author     Chuck Timber
 *  @date       09/08/2014
 */

#ifndef MBED_BUTTON2_H
#define MBED_BUTTON2_H

#include "mbed.h"
#include "button.h"

namespace mbed {

/** Class: BTN2
 *  A class handles button long press
 */
class BTN2 {

public:
    /// constructor
    BTN2(PinName pin);
    /** button return value
     *
     * @retval 1 - button pressed shortly
     * @retval 2 - button pressed longly
     */ 
    unsigned char CMD2;

private:
    /// use BTN lib
    BTN _btn;
    /// use Ticker for intaval timer
    Ticker _tick;
    /// button check function
    void check_btn_pressed(void);
};

}
#endif
