/**
 *  @file       main.cpp
 *  Project     Gem8 - handles 8-gembox synth project application
 *  @brief      Gem8 project application
 *  @version    1.0
 *  @author     Chuck Timber
 *  @date       11/27/2014
 */
 
#include "mbed.h"
#include "btn2.h"
#include "REnc.h"
#include "MIDI.h"
#include "midi_proc.h"
#include "I2CEEprom.h"

#include "midi_param.h"

// LED (active HIGH)
#define dbg_led_on()        { }
#define dbg_led_off()       { }

/// MIDI parameters -- 82-byte (32+32+18)
uint8_t midi_params[]={
    0,0,0,0,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,64,0,0,127,0,32,127,0,0,64,32,
};

uint8_t midi_cc_conv[] = {
    CC_MOD          , CC_FMOD         , CC_PWMOD        , CC_PORTA        ,
    CC_VOL          , CC_DAMPER       , CC_DETUNE       , CC_OSCMIX       ,
    CC_ENV1RELEASE  , CC_ENV1ATTACK   , CC_ENV1SUSTAIN  , CC_ENV1DECAY    ,
    CC_LFORATE      , CC_ENV2DECAY    , CC_ENV2ATTACK   , CC_PW           ,
    CC_CUTOFF       , CC_Q            
};

unsigned int randSeed;
static unsigned int tama;


// Random patch
void initRand(int x) {
    randSeed=x;
}
int nextRand(void) {
    randSeed=(1103515245*randSeed+12345)&2147483647;
    return (randSeed>>7)&0x7f;
}
void setupRandom(void) {
    srand( tama );
    initRand(rand());

    //randomset=1;
    midi_params[CC_MOD]=nextRand();
    midi_params[CC_FMOD]=nextRand();
    midi_params[CC_PWMOD]=nextRand();
    midi_params[CC_PORTA]=nextRand();
    midi_params[CC_ENV1ATTACK]=nextRand();
    midi_params[CC_ENV1DECAY]=nextRand();
    midi_params[CC_ENV1SUSTAIN]=nextRand();
    midi_params[CC_ENV1RELEASE]=nextRand();
    midi_params[CC_LFORATE]=nextRand();
    midi_params[CC_PW]=nextRand();
    midi_params[CC_OSCMIX]=nextRand();
    midi_params[CC_DETUNE]=nextRand();
    midi_params[CC_ENV2ATTACK]=nextRand();
    midi_params[CC_ENV2DECAY]=nextRand();
    midi_params[CC_CUTOFF]=nextRand();
    midi_params[CC_Q]=nextRand();
}

DigitalOut myled(LED2);
I2CEEprom i2crom(dp5, dp27, 0xa0);
MIDI midi(dp16, dp15);
DigitalOut RST(dp26);
BTN2 btn2(dp13);


int main() {
    int i;

    RST = 0;
    myled = 1;
    srand( 0 );
    initRand(rand());

    wait(1.0);
    RST = 1;

    midi_init();
    wait(1.0);
    
    for (i = 0; i < sizeof(midi_cc_conv); i++) {
        midi.sendControlChange(midi_cc_conv[i], midi_params[midi_cc_conv[i]], 1);
    }
    myled = 0;

//        midi.setInputChannel(1);

    while(1) {
        if (midi.read()) {
            tama++;
        }
        

        switch (btn2.CMD2) {
        case 1:
            myled = 1;
            setupRandom();
            for (i = 0; i < sizeof(midi_params); i++) {
                midi.sendControlChange(i, midi_params[i], 1);
            }
            myled = 0;
            btn2.CMD2 = 0;
            break;
        case 2:
            RST = 0;
            myled = 1;
            wait(1.0);
            RST = 1;
            for (i = 0; i < sizeof(midi_cc_conv); i++) {
                midi.sendControlChange(midi_cc_conv[i], midi_params[midi_cc_conv[i]], 1);
            }
            myled = 0;
            btn2.CMD2 = 0;
            break;
        }
        
    }
}

