/**
 *  @file       btn2.cpp
 *  Project     button long press handling sample
 *  @brief      button long press handling class
 *  @version    1.00
 *  @author     Chuck Timber
 *  @date       09/08/2014
 */

#include "btn2.h"

 BTN2::BTN2(PinName pin) : _btn(pin)
{
    _tick.attach(this, &BTN2::check_btn_pressed, 0.08);
}

void BTN2::check_btn_pressed(void)
{
    static int bcnt;

    if(_btn.CMD & _btn.STAT) {
        if (++bcnt > 15)
            CMD2 = 2;
    } else if (_btn.CMD & !_btn.STAT) {
        if ((bcnt > 0)&&(bcnt<=15))
            CMD2 = 1;
        _btn.CMD = 0;
        bcnt = 0;
    } else if (!_btn.CMD) {
        CMD2 = 0;
    }
}
