#ifndef __C_MIDI_PROC_H__
#define __C_MIDI_PROC_H__ 1

#include "mbed.h"
#include "MIDI.h"

extern MIDI midi;

#ifdef __cplusplus
//extern "C" {
#endif /* __cplusplus */

    /** MIDI System message */
#define MIDI_ALL_NOTE_OFF             0x7B
#define MIDI_RESET_ALL_CONTROLLERS    0x79

#define POLYPHONICE_NOTES 8

    /** @structure MIDI Note management structure
     *
     */
    typedef struct _MidiNote {
        /// MIDI Note number
        uint8_t Note;
        /// MIDI Note velocity
        uint8_t Velocity;
        /// MIDI Note channel
        uint8_t Channel;
        /// pointer to the next _MidiNote object
        struct _MidiNote *next;
    } MN_t, *MN_p;

    extern MN_t NoteEnd;
    extern MN_t NoteStart;
    extern MN_t MidiNotes[];
    extern uint16_t MidiNotesTag;
    extern uint8_t NumOfNotes;

    /** @brief Prototypes related to MIDI
     *
     */
    extern void midi_init(void);
    extern MN_p allocN(void);
    extern void freeN(MN_p addr);
    extern void midi_allnoteoff(void);
    extern void midi_resetcontrol(void);
    extern void midi_sysreset(void);
    extern void midi_noteoff(byte channel, byte note, byte velocity);
    extern void midi_noteon(byte channel, byte note, byte velocity);
    extern void midi_cc(byte channel, byte number, byte value);
    extern void midi_pc(byte channel, byte number);
    extern void midi_pbend(byte channel, int bend);

#ifdef __cplusplus
//}
#endif /* __cplusplus */
#endif /* __C_MIDI_PROC_H__ */