// http://robot.tamagawa.ac.jp:8080/cyber/mbed/i2c_memory.html

#include "I2CEEprom.h"
// 24LC64 の書き込み、読み込みテスト

//I2C  i2c(p9, p10); //p9: data, p10: clock

I2CEEprom::I2CEEprom():I2C(p9,p10)
{
  addr = 0xA0;
}
I2CEEprom::I2CEEprom(PinName data, PinName clock, int address):I2C(data, clock)
{
  addr = address;
}

void I2CEEprom::write(unsigned int address,  unsigned char data)
{
    start();
    ((I2C*)this)->write(addr);
    ((I2C*)this)->write((address>>8)&0xff);
    ((I2C*)this)->write(address & 0xff);
    ((I2C*)this)->write(data);
    stop();
}

unsigned char I2CEEprom::read(unsigned int address)
{
    unsigned char x;
    start();
    ((I2C*)this)->write(addr);
    ((I2C*)this)->write((address>>8)&0xff);
    ((I2C*)this)->write(address&0xff);
    start();
    ((I2C*)this)->write(addr+1);
    x = ((I2C*)this)->read(0);
    stop();
    return x;
}
