#include "mbed.h"
#include "RingBuffer.h"

//====================================================================================================================================
//                                 Konstruktor und Schreib/Lese Funktionen
//====================================================================================================================================

RingBuffer::RingBuffer(const int size){
    
    buffer_size = size;                                                         // Ringbuffergröße festlegen
    buffer.data = new uint32_t [size];                                          // Setzt die Dimension des Daten Arrays
    buffer.status = new uint8_t [size];                                         // Setzt die Dimension des Status Arrays
    buffer.status[0] = 0x00;                                                    // Kein Status vorhanden bei Beginn
    
    extfct = false;                                                             // Externe Funktion bei fast vollem Buffer
    bufferfull = false;                                                         // Buffer ist voll, kein Schreiben möglich 
    bufferempty = true;                                                         // Buffer ist leer, kein Lesen möglich
    read_pointer = 0;                                                           // Lesezeiger auf Null setzen
    write_pointer = 0;                                                          // Schreibezeiger auf Null setzen   
     
}

bool RingBuffer::writeBuffer(uint32_t inputdata){                               // Funktion zum beschreiben des Buffers

    if(!bufferfull){                                                            // Prüfen ob der Buffer voll ist

        buffer.data[write_pointer] = inputdata;                                 // Schreibt Daten in die aktuelle Zelle
        write_pointer++;                                                        // Zählt den Schreibezeiger um eins Hoch
        buffer.status[write_pointer] = buffer.status[write_pointer - 1];        // Übernehme den vorherigen Statuswert
         
        if(write_pointer == buffer_size){                                       // Zeiger am Ende des Buffers
            write_pointer = 0;                                                  // Schreibezeiger auf Null setzen   
        }
    
        if(extfct && (read_pointer + buffer_size - write_pointer) < 10){       // Externe Methode bei einem Abstand im Fifo von kleiner 10
            (*BUFFER_HANDLER)();                                               // Aufruf der Externen Funktion   
        }
           
        if(write_pointer == read_pointer){                                      // Schreibzeiger steht auf Lesezeiger
            bufferfull = true;                                                  // Buffer voll, kann nicht mehr Beschrieben werden

        }
        else{
            bufferempty = false;                                                // Buffer ist nicht leer, kann gelesen werden
     
        } 
      return true;                                                              // Rückgabe das der Wert beschrieben worden ist       
    } 
      return false;                                                             // Rückgabe das der Wert nicht beschrieben worden ist              
}

uint32_t RingBuffer::readBuffer(){                                              // Funktion zum beschreiben des Buffers

        uint32_t outputdata;                                                    // Variable zur Übergabe der Daten

    if(!bufferempty){                                                           // Prüfen ob der Buffer leer ist

        outputdata = buffer.data[read_pointer];                                 // Auslesen des Wertes an der aktuellen Stelle
        read_pointer++;                                                         // Zählt den Lesezeiger um eins Hoch
             
        if(read_pointer == buffer_size){                                        // Zeiger am Ende des Buffers
            read_pointer = 0;                                                   // lesezeiger auf Null setzen   
        }
    
        if(read_pointer== write_pointer){                                       // Lesezeiger steht auf Schreibzeiger
            bufferempty = true;                                                 // Buffer leer, kann nicht mehr gelesen werden
        }
        else{
            bufferfull = false;                                                 // Buffer ist nicht voll, kann geschrieben werden     
        }
        
    }
    else{                                                                       // Buffer leer
        outputdata = 0x00;                                                      // Rückgabe = 0
    }
                
    return outputdata;                                                          // Ausgabe des Werts
} 

//====================================================================================================================================
//                                 Setter und Getter Funktionen
//====================================================================================================================================

uint8_t RingBuffer::getBufferStatus(){ 
    return buffer.status[read_pointer];                                          // Rückgabe des aktuellen Statuswerts
}

bool RingBuffer::setBufferStatus(int bit){ 
    
    if(bit < 8){
        buffer.status[write_pointer] |= (1 << bit);                               // Setzt das vorher ausgewählte Bit
        return true;                                                              // Setzen erfolgreich.       
     }
        
     return false;                                                                // Setzen nicht erfolgreich.        
}

bool RingBuffer::resetBufferStatus(int bit){ 
    
    if(bit < 8){
        buffer.status[write_pointer] ^= (1 << bit);                               // Resetzt das vorher ausgewählte Bit
        return true;                                                              // Restzen erfolgreich.       
     }
        
     return false;                                                                // Resetzen nicht erfolgreich.        
}


void RingBuffer::setBF_METHODE(void (*EXTERN_BUFFER_HANDLER)(void)){              // Adresse zur externen Funktion übergeben und Freigabe setzen
          extfct = true;                                                          // Externe Funktion vorhanden. Freigabe setzen.
          BUFFER_HANDLER = EXTERN_BUFFER_HANDLER;                                 // Funktionspointer der Funktion übernehmen     
    }     