#include "mbed.h"
#include "AD5664.h"

//====================================================================================================================================
//                              Grundlagen, DAC Schreiben und Initialisieren
//====================================================================================================================================

AD5664::AD5664(SPI _spi, PinName _daccs): spi(_spi), daccs(_daccs)
{                                 
        sendDAC(0x2F, 0x00, 0x00);                                         //Software Reset, alle Ausgänge auf 0                                                              
    } 
  
  
void AD5664::sendDAC(int instruction = 0x00, int data1 = 0x00, int data2 = 0x00)
{        
        daccs = 0;                                                          // Select Device      
                                                       
                spi.write(instruction);                                     // Schreibt entsprechend die Anweisung und die Adresse                                     
                spi.write(data1);                                           // Schreibt den ersten Byte an Daten 
                spi.write(data2);                                           // Schreibt den zweiten Byte an Daten              
                 
        daccs = 1;                                                          // Deselect                                                                         
    }     

//====================================================================================================================================
//                              Setter-Funktionen
//====================================================================================================================================

void AD5664::SelectCS()
{         daccs = 0;                                                        // Select Device                              
    }

void AD5664::DeselectCS()
{          daccs = 1;                                                       // Deselect  
    }  
    
void AD5664::writeDAC(char channel, int value)
{
        int choch = 0x00;                                                    //Temporäre Variable um die Instructions zu übernehmen
            
            switch(channel){
                    case 'A':                                                // DAC A
                        choch = 0x18;
                    break;
                    
                    case 'B':                                                // DAC B
                        choch = 0x19;
                    break;
                    
                    case 'C':                                                // DAC C
                        choch = 0x1A;
                    break;   

                    case 'D':                                                // DAC D
                        choch = 0x1B;
                    break;                

                    case 'F':                                                // Alle Dacs
                        choch = 0x1F;
                    break;
                    
                    default:
                        choch = 0x1F;                                       // Alle Dacs
                    }      
                                                                     
    sendDAC(choch, *((uint8_t*)&(value)+1), *((uint8_t*)&(value)+0));      //Schreibe via SPI: Anweisung mit Adresse, oberes Byte, unteres Byte)                                                                      
           
    }
      


void AD5664::loadDAC(char channel, int value)
{
        int choch = 0x00;                                                    //Temporäre Variable um die Instructions zu übernehmen
            
            switch(channel){
                    case 'A':                                                // DAC A
                        choch = 0x00;
                    break;
                    
                    case 'B':                                                // DAC B
                        choch = 0x01;
                    break;
                    
                    case 'C':                                                // DAC C
                        choch = 0x02;
                    break;   

                    case 'D':                                                // DAC D
                        choch = 0x03;
                    break;                

                    case 'F':                                                // Alle Dacs
                        choch = 0x07;
                    break;
                    
                    default:
                        choch = 0x07;                                       // Alle Dacs
                    }      
                                                                     
    sendDAC(choch, *((uint8_t*)&(value)+1), *((uint8_t*)&(value)+0));      //Schreibe via SPI: Anweisung mit Adresse, oberes Byte, unteres Byte)                                                                      
           
    }
    
    
void AD5664::updateDAC(char channel)
{
        int choch = 0x00;                                                    //Temporäre Variable um die Instructions zu übernehmen
            
            switch(channel){
                    case 'A':                                                // DAC A
                        choch = 0x08;
                    break;
                    
                    case 'B':                                                // DAC B
                        choch = 0x09;
                    break;
                    
                    case 'C':                                                // DAC C
                        choch = 0x0A;
                    break;   

                    case 'D':                                                // DAC D
                        choch = 0x0B;
                    break;                

                    case 'F':                                                // Alle Dacs
                        choch = 0x0F;
                    break;
                    
                    default:
                        choch = 0x0F;                                       // Alle Dacs
                    }      
                                                                     
    sendDAC(choch, 0x00 , 0x00);      //Schreibe via SPI: Anweisung mit Adresse, oberes Byte, unteres Byte)                                                                      
           
    }
