
#include "Config.h"
#include "mbed.h"
#include "RemoteFunc.h"

//Set Up Debug Environment
IMPLEMENT_DBUG;

Ticker tkInterrupt;

DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led3(LED3);
DigitalOut Led4(LED4);

const float fWait(1.0);

long nIntegrand(0);

int main()
{
  DBUG_INIT(8);

  while(true)
  {
    TRACE("Beginning of Loop\n\r");
    WATCH("Integrand     %6ld", nIntegrand++);

    if (nIntegrand % 3)
      RemoteFunction(nIntegrand);
      
    // Display Diagnostics LEDs
    Led1 = (nIntegrand % 2 == 0);
    Led2 = (nIntegrand % 3 == 0);
    Led3 = (nIntegrand % 4 == 0);
    Led4 = (nIntegrand % 5 == 0);
    WATCH("%s", Led1 ? "^RLED 1^r" : "LED 1");
    WATCH("%s", Led2 ? "^RLED 2^r" : "LED 2");
    WATCH("%s", Led3 ? "^RLED 3^r" : "LED 3");
    WATCH("%s", Led4 ? "^RLED 4^r" : "LED 4");
    TRACE("Waiting for %2.1f Seconds\n\r", fWait);
    wait(fWait);
    TRACE("End Of Loop\n\r");
  }
}