#pragma once
#include <stdarg.h>
#include "mbed.h"

class CVT100
{
public:
    CVT100(void);
    ~CVT100(void);
    enum {Rows = 24, Columns = 80};
//Attributes
Serial* m_pVT100;

//Interface
void printf(const char *lpszFormat, ...);
void printf(unsigned char nCol, unsigned char nRow, const char *lpszFormat, ...);
void vprintf(const char *lpszFormat, va_list);
void vprintf(unsigned char nCol, unsigned char nRow, const char *lpszFormat, va_list);
void ClearScreen(void);
void SaveCursor(void);
void CursorOff(bool bOff = true);
void RestoreCursor(void);
void MoveXY(unsigned char nCol, unsigned char nRow);
void SetScroll(unsigned char nStart, unsigned char nEnd);
void PutString(const char *lpszOutput);
char* FormatString(const char *lpszFormat);
};