#include "VT100.h"
class CDBug
{
public:
	CDBug(void);
	~CDBug(void);

//Attributes
protected:
	CVT100 m_VT100;
	unsigned char m_nWatches;
	unsigned char m_nScrollLimit;
	unsigned char m_nNextWatch;
// Interface
public:
	void Init(unsigned char nWatches);
	void Trace(char *lpszFormat, ...);
	void Watch(unsigned char &hHandle, const char *lpszFormat, ...);

};

#ifdef DECLARE_DEBUG
extern CDBug DBug;
#endif // DECLARE_DEBUG

/**********************************************************
* Comment Out The Line Below For Release Compiler Version *
**********************************************************/
#define DECLARE_DEBUG

#ifdef DECLARE_DEBUG
#define IMPLEMENT_DBUG CDBug DBug;
#define DBUG_INIT(a) DBug.Init(a)
#define TRACE(...) DBug.Trace(__VA_ARGS__)
#define WATCH(...)\
{\
	static unsigned char hHandle(0);\
	DBug.Watch(hHandle, __VA_ARGS__);\
}
#else
#define IMPLEMENT_DBUG
#define DBUG_INIT(a)
#define TRACE(...)
#define WATCH(...)
#endif //DECLARE_DEBUG