#include "VT100.h"
#include "DBug.h"

CDBug::CDBug()
	: m_nWatches(0)
	, m_nScrollLimit(CVT100::Rows)
	, m_nNextWatch(0)
{
}

CDBug::~CDBug(void)
{
}

void CDBug::Init(unsigned char nWatches)
{
  m_nWatches = nWatches > CVT100::Rows * 2 ? CVT100::Rows * 2 : nWatches;
  m_nScrollLimit = CVT100::Rows - ((m_nWatches + 1) / 2) - 1;
  m_VT100.ClearScreen();
  m_VT100.CursorOff();
  m_VT100.printf(0, 0, "^_^RTRACE OUTPUT...^r");
  m_VT100.printf(0, m_nScrollLimit + 1, "^RWATCHES...^r");
  m_VT100.SetScroll(2, m_nScrollLimit);
  m_VT100.MoveXY(0, 2);
}
																																																															 //
void CDBug::Trace(char *lpszFormat, ...)
{
	va_list	args;
	va_start(args, lpszFormat);
	m_VT100.vprintf(lpszFormat, args);
	va_end(args);
}

void CDBug::Watch(unsigned char &hHandle, const char *lpszFormat, ...)
{
  if (!hHandle && (m_nNextWatch <= m_nWatches))
  {
	hHandle = ++m_nNextWatch;
  }
  if (hHandle)
  {
	va_list	args;
	va_start(args, lpszFormat);
	m_VT100.vprintf(hHandle & 1 ?  0 : CVT100::Columns / 2, m_nScrollLimit + 2 + ((hHandle - 1) / 2), lpszFormat, args);
	va_end(args);
  }
}
