#include "MMiniFileReader.h"
#include <iostream>
#include <fstream>
#include "mbed.h"
#include <sstream>
#include <string>

using namespace std;

iniFileReader::iniFileReader()
{
}


iniFileReader::~iniFileReader()
{
}

iniFile iniFileReader::ReadFile(const char* filePath)
{
    iniFile fileConfig;

    char line[32];
    //std::ifstream myfile(filePath);

    //Serial pc(USBTX, USBRX);


    //std::ifstream myfile("filePath");

    //pc.printf("file=%s \n", filePath);

    FILE *File2 = fopen(filePath, "r"); // open file for reading
                                                                                            //fgets(read_string,256,File2); // read first data value
    //pc.printf("text data: %s \n", read_string);


    if (File2)
    {
        char section[32];

        while (fgets(line, 32, File2))
        {

            if (IsSection(line))
            {
                 GetSectionName(line, section);
            } 
            else
            {

                if ( strncmp(section , "Station", 7) == 0)
                {
                    char paramName[32];
                        
                    GetParamName(line, paramName);

                    if (strncmp(paramName, "ID", 2) == 0)
                          GetParamValue(line, fileConfig.Station.ID);
                    
                    if (strncmp(paramName, "Name", 4) == 0)
                         GetParamValue(line, fileConfig.Station.Name);

                    if (strncmp(paramName, "ComsType", 8 ) == 0)
                         GetParamValue(line, fileConfig.Station.ComsType);

                    if (strncmp(paramName, "IPAddress",9) == 0)
                          GetParamValue(line, fileConfig.Station.IPAddress);

                    if (strncmp(paramName, "NetworkMask", 11) == 0)
                          GetParamValue(line, fileConfig.Station.NetworkMask);

                    if (strncmp(paramName, "DefaultGateway", 14) == 0)
                          GetParamValue(line, fileConfig.Station.DefaultGateway);

                    if (strncmp(paramName, "DataSendTime", 12) == 0)
                          GetParamValue(line, fileConfig.Station.DataSendTime);
                }


                if (strncmp(section, "Server", 6) == 0)
                {
                    char paramName[32];

                    GetParamName(line, paramName);

                    if (strncmp(paramName, "IPAddress", 9) == 0)
                        GetParamValue(line, fileConfig.Server.IPAddress);

                    if (strncmp(paramName, "Port", 4) == 0)
                         GetParamValue(line, fileConfig.Server.Port);
                }

                ReadSensorSection(section, "Sensor1",7, line, &fileConfig.Sensor1);
                ReadSensorSection(section, "Sensor2", 7, line, &fileConfig.Sensor2);
                ReadSensorSection(section, "Sensor3", 7, line, &fileConfig.Sensor3);
                ReadSensorSection(section, "Sensor4", 7, line, &fileConfig.Sensor4);
                ReadSensorSection(section, "Sensor5", 7, line, &fileConfig.Sensor5);
                ReadSensorSection(section, "Sensor6", 7, line, &fileConfig.Sensor6);
                ReadSensorSection(section, "Sensor7", 7, line, &fileConfig.Sensor7);
                ReadSensorSection(section, "Sensor8", 7, line, &fileConfig.Sensor8);
                ReadSensorSection(section, "Sensor9", 7, line, &fileConfig.Sensor9);
                ReadSensorSection(section, "Sensor10", 8, line, &fileConfig.Sensor10);

            }


        }
        fclose(File2);
    }

    return fileConfig;
}


void iniFileReader::ReadSensorSection(char currentSection[], char section[], int size, char line[], iniSensor *sensor) 
{

    if (strncmp(currentSection, section, size) == 0)
    {
        char paramName[32];

        GetParamName(line, paramName);

        if (strncmp(paramName, "ID", 2) == 0)
             GetParamValue(line, (*sensor).ID);

        if (strncmp(paramName, "Type",4) == 0)
             GetParamValue(line, (*sensor).SensorType);

        if (strncmp(paramName, "Enabled", 7) == 0)
             GetParamValue(line, (*sensor).Enabled);

        if (strncmp(paramName, "SampleTime",10) == 0)
             GetParamValue(line, (*sensor).SampleTime);

        if (strncmp(paramName, "DataSampleQty",13) ==0 )
              GetParamValue(line, (*sensor).DataSampleQty);

        if (strncmp(paramName, "Pins", 4) == 0 )
             GetParamValue(line, (*sensor).Pins);

        if (strncmp(paramName, "SensorOptions", 13) == 0)
              GetParamValue(line, (*sensor).SensorOptions);
    }

}



bool iniFileReader::IsSection(char line[])
{
    if (line[0] == '[')
    {
        return true;
    }

    return false;
}

void iniFileReader::GetSectionName(char line[], char* result)
{
    int start = 0;

    for (int i = 1; i < 32; i++) {
        if (line[i] == ']') {
            result[start] = '\n';
            break;
        }
            

        result[start] = line[i];
        start++;
    }


    //int pos = line - 2;
    //string sectionName = line.substr(1, pos);

    //return sectionName;
}

void iniFileReader::GetParamName(char line[], char* result)
{

    for (int i = 0; i < 32; i++) {
        if (line[i] == '=')
            break;

        result[i] = line[i];
    }

}

void iniFileReader::GetParamValue(char line[], char* result)
{
    bool found = false;
    int start = 0;

    for (int i = 0; i < 32; i++) {

        if (!found) {
            if (line[i] == '=')
                found = true;
        }
        else
        {
            if (line[i] != '\n' && line[i] != NULL)
                result[start] = line[i];
            else
                {
                    result[start] = '\0';
                    break;
                }                

            start++;
        }
    }
}