#include "Coms.h"
#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"

EthernetInterface eth;
TCPSocketConnection sock;

int Coms::EthernetInitialise (char* IPAddress, char* NetworkMask, char* DefaultGateway)
{
    int error;
    int retrys = 5;
    int retval;
    
    while (true)
    {
                    
        error = eth.init(IPAddress, NetworkMask, DefaultGateway); // Use static IP
        
        if (error) {
            printf("Error: Could not initialise ethernet (code %i) - Retry (%d)...\r\n", error, retrys);
            Thread::wait(5000);
            retrys--;
            if (retrys)
                continue;
            else
                retval=error;
                break;
        }
        else {
            printf("Ethernet Initialised\r\n");
            retval=0;
        }
        break;
    }
    return retval;
 }       

char* Coms::getMACAddress()
{
    return eth.getMACAddress();
}
        
int Coms::EthernetConnect()
{
    int error;
    int retrys = 5;      
    int retval;
        
    while (true)
    {
        error = eth.connect(30000);
        if (error) {
            printf("Error: Could not obtain IP address (code %i) - Retry (%d)...\r\n", error, retrys);
            retrys--;
            if (retrys)
                continue;
            else
                retval=error;
                break;
        }
        else {
            printf("Ethernet connected\r\n");
            retval=0;
        }        
        break;
    }
    return retval;
}

void Coms::EthernetDisconnect()
{
    eth.disconnect();
}

int Coms::EthernetSocketConnect (char* IPAddress, int Port)
{
    int error;
    int retrys = 5;
    int retval;
    
    while (true)
    {
                    
        error = sock.connect(IPAddress, Port);
        
        if (error) {
            printf("Error: Could not connect (code %i). Retry (%d) in 2s...\r\n", error, retrys);
            Thread::wait(2000);
            retrys--;
            if (retrys)
                continue;
            else
                retval=error;
                break;
        }
        else {
            retval=0;
            printf("Socket Connected\r\n");
        }
        break;
    }
    return retval;
 }  
 
 int Coms::EthernetSocketSendAll (char* datasample, int samplesize)
{
    int error;
    int retrys = 5;
    int retval;
    
    while (true)
    {
                    
        //error = sock.send_all(datasample, sizeof(datasample)-1);
        error = sock.send_all(datasample, samplesize);
        
        printf("Sending %s length %i\r\n",datasample,samplesize);
        
        if (error<1) 
        {
            printf("Error: Could not send http request (code %i) - Retry (%d) in 1s...\r\n", error, retrys);
            Thread::wait(1000);
            retrys--;
            if (retrys)
                continue;
            else
                retval=error;
                break;
        }
        printf("Message Sent\r\n");
        retval=0;
        break;
    }
    return retval;
 } 
 
 
  int Coms::EthernetSocketReceive (char* datasample, int samplesize)
{
    int retval;
    retval = sock.receive(datasample, samplesize);
    return retval;   
 }
 
 int Coms::EthernetSocketClose()
 {
     sock.close();
 }