/*
 * 3ATIBoardIO.h
 *
 *  Created on: Mar 24, 2018
 *      Author: chrisbailey
 */

#ifndef INC_3ATIBOARDIO_H_
#define INC_3ATIBOARDIO_H_
#include "mbed.h"

#define LED_PIN         D13  // On board LED also connected to pin 16 of board
//#define FLS_OK_PIN      D12 //PB_4 Pin 15 of board labeled "D11" to Test Port 17
#define TEMP_OK_PIN     D11 // PB_5 PIN 14 of board labled "D11" to Main Port 28
#define BIT_PIN         D10 // PA_11 Pin 13 of board labeled "D10" to Main 32
//
// Output Pins
//
#define PWM_PIN         D9 // PA_8 Pin 12 of board labeled "D9" to Main 29
#define DAY_NIGHT_PIN   D8 //PF_1 Pin 11 of board labeled "D8" to Main 30
#define RESET_PIN       D7 //PF_0 Pin 10 of board labeled "D7" to Main 36
                    //  D6  Used as analog pin
//#define I2C_SCL_PIN     D5 // PB_6 Pin 8 of board labeled "D5" to Test 11
//#define I2C_SDA_PIN     D4 // PB_7 Pin 7 of Board labeled "D4" to Test 13
                    //  D3 Used as analog pin
                    //  D2 Available
#define BIT2_PIN        D1 //only used with Intellisense adapter board
#define BIT3_PIN        D0 //only used with Intellisense adapter board


// Analog pins
#define LCD_TEMP_PIN        A0  // PA0 Pin 19 on Board to Main 35
#define LED_TEMP_PIN        A1  // PA1 Pin 20 on Board to Main 38
#define LCD_TEMP2_PIN       A2  // PA3 Pin 21 on Board 
#define LED1_CURRENT_PIN    A3  // PA4 Pin 22 on Board to Test 4
                        //  A4  // PA5 Pin 23 on Board  // may conflict with i2C unless we remove sb 18
                        //  A5  // PA6 Pin 24 on Board to Test 16 // may conflict with i2C unless we remove sb 16
#define LED2_VOLTAGE_PIN    A6  // PA7 Pin 25 on Board to Test 18
#define LED2_CURRENT_PIN    A5  // PA2 Pin 26 on Board to Test 6
#define LED1_VOLTAGE_PIN    D6  // PB1 Pin 9 on board (can be uded for analog)to Test 16
#define FLS_VOLTAGE_PIN     D3  // PB_0 Pin 6 on Board Main 36


// return floats between 0 and 1.0 corisponding to 0 to 3.3V
extern AnalogIn lcdTemp;          
extern AnalogIn lcdTemp2;  // when using intellisense adaprer board
extern AnalogIn ledTemp;     
extern AnalogIn led1Current;
extern AnalogIn led2Current;
extern AnalogIn led1Voltage;   
extern AnalogIn led2Voltage; 
extern AnalogIn flsVoltage; 

extern Serial pc;
extern I2C i2c;

extern DigitalIn bit;
extern DigitalIn bit2;
extern DigitalIn bit3;
extern DigitalIn tempOk;
extern DigitalIn flsOk;
extern DigitalOut reset;
extern DigitalOut dayNight;
extern DigitalOut led1;
extern PwmOut pwm;

#endif /* INC_3ATIBOARDIO_H_ */
