#ifndef D6F_PH_H
#define D6F_PH_H

#define D6F_ADDR 0xD8

class D6F_PH{
    private:
        I2C *_i2c;
    
        // D6F-PH function
        char d6f_config[5];
        char d6f_comp_read[4];
        char d6f_temp_read[4];
        char d6f_mem_read[1];
        char d6f_init[2];
         
    public:
        
        /** Constructor - create a connection to a D6F-PH diff-pressure and reference temperature sensor
          * through an I2C interface
          *
         * @param *i2c a pointer to the i2c interface that is used for communication
         */             
        D6F_PH(I2C *i2c);
            
        /** Read the diff-pressure value from the sensor \n
         *
         *
         *
         *
         *
         * @param returns a value representing the temperature in degrees centigrade
         */
        float read_pressure();
    
        /** Read the reference temperature value from the sensor \n
         *
         *
         *
         *
         *
         * @param returns the percentage humidity
         */
        float read_d6f_temp();
    
        /**
         * Perform a soft-reset of the sensor unit.
         */
        uint8_t init();
        
};
    
#endif // D6FS_PH_H