 #include "mbed.h"
 #include "D6F-PH.h"

 
 // Class constructor

D6F_PH::D6F_PH(I2C *i2c) :
_i2c(i2c){
}


float D6F_PH::read_pressure(void) {
    char error;
    char rdata[2];
    uint16_t raw_diff_pa;
    float diff_pa;
    
    error = _i2c->write(D6F_ADDR, d6f_config, 5);
    wait_us(40000);
    error |= _i2c->write(D6F_ADDR, d6f_comp_read, 4);
    error |= _i2c->write(D6F_ADDR, d6f_mem_read, 1, true);
    error |= _i2c->read(D6F_ADDR, rdata, 2);
    if(error) {
        return(error);
    }
    raw_diff_pa = (rdata[0]<<8) + rdata[1];
    diff_pa = ((float)raw_diff_pa-1024)/600 - 50;    
    return(diff_pa);   
}


float D6F_PH::read_d6f_temp(void) {
    char error;
    char rdata[2];
    uint16_t raw_ref_temp;
    float ref_temp;
    
    error = _i2c->write(D6F_ADDR, d6f_config, 5);
    wait_us(40000);
    error |= _i2c->write(D6F_ADDR, d6f_temp_read, 4);
    error |= _i2c->write(D6F_ADDR, d6f_mem_read, 1, true);
    error |= _i2c->read(D6F_ADDR, rdata, 2);
    if(error) {
        return(error);
    }
    raw_ref_temp = (rdata[0]<<8) + rdata[1];
    ref_temp = ((float)raw_ref_temp-10214)/37.39;
    return(ref_temp);   
}

uint8_t D6F_PH::init(void) {
    uint8_t error;
    
    // Init config cmd
    //d6f_config[5] = {0x00, 0xD0, 0x40, 0x18, 0x06};
    d6f_config[0] = 0x00;
    d6f_config[1] = 0xD0;
    d6f_config[2] = 0x40;
    d6f_config[3] = 0x18;
    d6f_config[4] = 0x06;
    
    //d6f_comp_read[4] = {0x00, 0xD0, 0x51, 0x2C};
    d6f_comp_read[0] = 0x00;
    d6f_comp_read[1] = 0xD0;
    d6f_comp_read[2] = 0x51;
    d6f_comp_read[3] = 0x2C;
    
    //d6f_temp_read[4] = {0x00, 0xD0, 0x61, 0x2C};
    d6f_temp_read[0] = 0x00;
    d6f_temp_read[1] = 0xD0;
    d6f_temp_read[2] = 0x61;
    d6f_temp_read[3] = 0x2C;
    
    //d6f_mem_read[1] = {0x07};
    d6f_mem_read[0] = 0x07;
    
    d6f_init[0] = 0x0B;
    d6f_init[1] = 0x00;
    error = _i2c->write(D6F_ADDR, d6f_init, 2);
    
    return(error);
}

