
#include "mbed.h"
#include "TextLCD.h"
/*
#define MODO 0
#define ESTERELIZADO 1
#define ESC_RAPIDO 2
#define ESC_LENTO 3
#define SECADO 4
#define DRENADO 5
*/
DigitalOut green(LED2);
DigitalOut valvula(D4);
DigitalIn  Select(PC_10);
DigitalIn  Acept(PC_11);
DigitalIn  Abort(PD_2);
AnalogIn AnaValue(A1);

TextLCD lcd1(PC_2,PC_3,PC_0,PC_1,PB_0,PA_4); // rs, e, d4-d7
TextLCD lcd2(PC_12,PA_13,PA_14,PA_15,PB_7,PC_13); // rs, e, d4-d7

    //DigitalOut led_a(PC_10);
    //DigitalOut led_b(PC_11);
    //DigitalOut led_c(PC_12);
    //DigitalOut led_d(PD_2);
    //DigitalOut led_e(PA_13);
    //DigitalIn  Abort(RESET_BUTTON);
    
unsigned char final_value;
void readtemp(){
    float value = 0;
    value  = AnaValue.read();
    value = (value*3300)/10;
    final_value = (int)value;
}
unsigned char read_button(DigitalIn button){
    unsigned hold_up = 0;
    unsigned hold_down = 0;
    while(1){
        if(button.read()) {
            hold_up++;   
        } else {
            hold_down++;
        }
        if((hold_up > 500000) || (hold_down > 500000)){
            break;
        }       
    }
    if(hold_up >= hold_down) {
        return 1;
    } else {
        return 0;
    }    
}

typedef enum est{MODO,ESTERELIZADO,ESC_RAPIDO,ESC_LENTO,SECADO, DRENADO}Estado;


int main()
{
    unsigned char change = 0;
    unsigned counter = 0;
    valvula = 0;
    while(1) {
        lcd1.cls();
        lcd2.cls();
        lcd1.printf("Op. Actual: ModoOp. Select: Auto");
        lcd2.printf("Seleccione ");
        while(!read_button(Acept)){
            if(read_button(Select)){
                change = !change;
                lcd1.cls();
                if (change){
                    lcd1.printf("Op.Actual: Mode\nOp.Select: Auto");
                    valvula = 1;
                } else {
                    lcd1.printf("Op.Actual: Mode\nOp.Select:Manual");
                    valvula = 0;
                }
            }
            if (read_button(Abort)){break;}
        }
        if(read_button(Acept)){wait(.01);}
        while(!read_button(Acept)) {
            lcd1.cls();
            lcd2.cls();
            readtemp();
            lcd2.printf("Esterelizado\nOp.Select: Auto");
            lcd1.printf("TpD %d   TpC %d PsD %d   PsC %d", final_value,final_value,final_value,final_value);
            if (read_button(Abort)){break;}
        }
        if(read_button(Acept)){wait(.01);}
        while(!read_button(Acept)) {
            lcd1.cls();
            lcd2.cls();
            readtemp();
            lcd2.printf("Escape Rapido\nOp.Select: Auto");
            lcd1.printf("TpD %d   TpC %d PsD %d   PsC %d", final_value,final_value,final_value,final_value);
            if (read_button(Abort)){break;}
        }
        if(read_button(Acept)){wait(.01);}
        while(!read_button(Acept)) {
            lcd1.cls();
            lcd2.cls();
            readtemp();
            lcd2.printf("Escape Lento\nOp.Select: Auto");
            lcd1.printf("TpD %d   TpC %d PsD %d   PsC %d", final_value,final_value,final_value,final_value);
            if (read_button(Abort)){break;}
        }
        if(read_button(Acept)){wait(.01);}
        while(!read_button(Acept)) {
            lcd1.cls();
            lcd2.cls();
            readtemp();
            lcd2.printf("Secado\nOp.Select: Auto");
            lcd1.printf("TpD %d   TpC %d PsD %d   PsC %d", final_value,final_value,final_value,final_value);
            if (read_button(Abort)){break;}
        }
        if(read_button(Acept)){wait(.01);}
    }
}