//
// Toggle running with reset button  by K.Shibata
// 
// Push reset button to stop running.
// Push reset button to run again. 
//

#include "mbed.h"

DigitalOut myled(LED1);

LocalFileSystem local( "local" );   // Create the local filesystem under the name "local"

int main() {
    FILE *fp;
    bool is_checked = false;

    fp = fopen( "/local/toggle.txt", "r" ); // Open "toggle.txt" on the local file system for reading.
    if ( fp != NULL ) {
        int c = fgetc( fp );
        if ( c == '1' ) {
            is_checked = true;
        }
        fclose( fp );
    }

    fp = fopen( "/local/toggle.txt", "w" ); // Open "toggle.txt" on the local file system for writing.
    if ( fp != NULL ) {
        if ( is_checked ) {
            fputc( '0', fp );
        } else {
            fputc( '1', fp );
        }
        fclose( fp );
    }

    if ( is_checked ) while( 1 ); // Infinite loop.

    while (1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
