/*
 * Copyright (c) 2017 Koichi Shibata
 */

#ifndef SPIKE_REMOVE_FILTER_H
#define SPIKE_REMOVE_FILTER_H

#include "mbed.h"

template <class T> class SpikeRemoveFilter
{
protected:

    T x0; // latest data
    T x1;
    T x2; // oldest data

public:

    // Constructor
    SpikeRemoveFilter( void );

    // Destructor
    virtual ~SpikeRemoveFilter( void );

    T process( T x );
    
    static int size( void ) { return 3; }

};

// Constructor
template <class T> SpikeRemoveFilter<T>::SpikeRemoveFilter( void )
{
}

// Destructor
template <class T> SpikeRemoveFilter<T>::~SpikeRemoveFilter( void )
{
}

template <class T> T SpikeRemoveFilter<T>::process( T x )
{
    x2 = x1;
    x1 = x0;
    x0 = x;
    if ( x1 < x2 ) {
        if ( x0 < x1 ) {
            return x1;
        } else if ( x2 < x0 ) {
            return x2;
        } else {
            return x0;
        }
    } else { // x2 <= x1
        if ( x0 < x2 ) {
            return x2;
        } else if ( x1 < x0 ) {
            return x1;
        } else {
            return x0;
        }
    }
}

#endif

