#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"
#include "FsHandler.h"
#include "getData.h"
#include "rtos.h"
#include "OneWire_Functions.h"


EthernetInterface eth;            // define Ethernet interface
LocalFileSystem fs("webfs");      // define Local file system
HTTPServer svr;                   // define HHTP server object
Thread Threadtemp;
Thread threadsvr;
Serial pc(USBTX,USBRX);
OneWire owp(p21);

void threadstart()
{
    eth.init();
    eth.connect();
    HTTPFsRequestHandler::mount("/webfs/","/");
    svr.addHandler<HTTPFsRequestHandler>("/");
    //add the path to the request handler
    svr.addHandler<getData>("/setreso");
    svr.addHandler<getData>("/get");
    svr.addHandler<getData>("/setalert");

    svr.start(80,&eth);// start the web server
    while(1) {
        svr.poll();// continuously poll for Ethernet messages to server

// address to locate index
// http://192.168.1.100/index.htm
    }
}
void readData()
{
    pc.printf("\n\rStarting Initilization One Wire Device...\n\r");
    //set resolution and alarm temperature to default.
    owp.Change_Res();
    pc.printf("\n\rFinish Initilization.\n\r");


    while(1) {
        
        pc.printf("\n\rNow Searching Alarm...\n\r");
        
        if(owp.Read_alarm_Email()) {

            pc.printf("\n\rFound one device is alarming.\n\r");
            //pc.printf("\n\r");

        } else {
            pc.printf("No device is alarming\n\r");

        }
        Threadtemp.wait(10000);
    }
}

int main()
{

    pc.printf("\n\rStart server");
    threadsvr.start(threadstart);

    pc.printf("\n\rStart read temp");
    Threadtemp.start(readData);

}

