#ifndef OneWire_Functions
#define OneWire_Functions

#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "SimpleSMTPClient.h"

#define DOMAIN "DOMAIN.net"
#define SERVER "smtp-mail.outlook.com"
#define PORT "587"
#define USER "hotmanson@outlook.com"
#define PWD "chester1551"
#define FROM_ADDRESS "hotmanson@outlook.com"
#define TO_ADDRESS "hotmanson@outlook.com"
#define SUBJECT "Cluster is Buring!"

#define OneWireDevNu 5
#define OneWireTempReg OneWireDevNu*2

#define Ninebitresolution 0x1f
#define Tenbitresolution 0x3f
#define Elevenbitresolution 0x5f
#define Twebitresolution 0x7f

#define FALSE 0
#define TRUE  1

class OneWire
{
public:
    OneWire (PinName wire); //define 1-wire I/O pin

    //DS1822 Quick Commands
    //search the alarm on the bus. if ture, send email.
    int Read_alarm_Email();
    //read all temp on the bus
    int Read_Temp_On_bus();
    //set resolution or alarm temp to all device
    void Change_Res();
    //all temperture data
    char  alltemp[OneWireTempReg];
    //set resolution and alarm trigger temperature
    char sca[3];
        
private:
    
    //static OneWire* uniqueInstance;
    DigitalInOut _pin;


    //One Wire Basic Communication Protocol
    //base functions
    int init();
    void write_bit(uint8_t data);
    int read_bit();

    //Advance Communication Protocol
    void write_byte(uint8_t data);
    int read_byte();

    //DS1822 Function
    //char* init_Match_Read_Scratchpad(char addr[8]);
    char* init_Match_Get_Temp(char addr[8]);
    void init_Match_Write_Scratchpad(char addr[8], char Scratchpad[1]);
    //all device on the bus convert t
    int Skip_Convert_T();

    //One Wire Search Algorithm
    // method declarations
    int  OWFirst();
    int  OWNext();
    int  OWVerify();
    void OWTargetSetup(unsigned char family_code);
    void OWFamilySkipSetup();
    int  OWSearch();
    unsigned char docrc8(unsigned char value);
    int OWSearch_alarm();

    //Search Result
    char ROM_NO[8];
    int LastDiscrepancy;
    int LastFamilyDiscrepancy;
    int LastDeviceFlag;
    unsigned char crc8;
    
    //resulotion
    uint8_t reso;
    //For Email Client
    NTPClient ntp;
    SimpleSMTPClient smtp;
    
    //Unused Function
    //char* init_Read_ROM();
    //char* init_Skip_Get_Temp();
    //int init_Skip_Read_Scratchpad();
    //void init_Skip_Write_Scratchpad(char Scratchpad[7]);

    //One Wire ROM function
    //int Read_ROM();
    //void Match_ROM(char addr[8]);
    //void Skip_ROM();

    //DS1822 Function
    //int Convert_T();
    //int Read_Scratchpad();
    //void Write_Scratchpad(char Scratchpad[7]);

    // definitions


};

#endif