#include"mbed.h"
#include"getData.h"
#include"OneWire_Functions.h"
#include "HTTPServer.h"

OneWire ow(p21);
Serial pc1(USBTX,USBRX);
getData::getData(const char* rootPath, const char* localPath, HTTPConnection::HTTPMessage& Msg, TCPSocketConnection& Tcp)
    : HTTPRequestHandler(Msg, Tcp)// inherit from HttpRequestHandler 
{
    m_rootPath = rootPath;
    m_localPath = localPath;
    handleRequest();
}
getData::~getData()
{
}

int getData::handlePutRequest()
{
    return 404;
}
int getData::handlePostRequest()
{
    return 404;
}

std::string getData::getpath()
{
    return m_rootPath;
}
/** Handler function to serve GET requests. Download ressource from server from \c uri location.
        */
int getData::handleGetRequest()
{
    char outBuf[1024] = {}; // the web page buffer 
    char htpmsg[10]= {};   //http message  
    char h1[5]= {};
    char h2[1]= {};
    bool retval = false;
    int err = 404;
    int i=0;
    int m=0;
    int h,j=8;
    int16_t d1,d2,d3,d4,d5;
    float t1,t2,t3,t4,t5;
    float config;
    char temp;
    map<string ,string >::iterator iter;// interation the map 
    
    strncpy(htpmsg,msg.uri.c_str(),msg.uri.length());// convert the string to char* 
 // if  recive the path "get" eg:127.0.0.1/get/  we will get the data from onewire. 
    if(strcmp(htpmsg,"/get")==0) {

        if(ow.Read_Temp_On_bus()) {
            //Get the resolution from onewire, there are some different arguments ot calculate the temperture
            if(ow.sca[0]==0x1f) {
                h=3;
                config=0.5;
            } else if(ow.sca[0]==0x3f) {
                h=2;
                config=0.25;
            } else if(ow.sca[0]==0x5f) {
                h=1;
                config=0.125;
            } else if(ow.sca[0]==0x7f) {
                h=0;
                config=0.0625;
            }
            // calculate the temperture 
            d1=((ow.alltemp[9]<<(j-h))|(ow.alltemp[8]>>h));
            d2=((ow.alltemp[7]<<(j-h))|(ow.alltemp[6]>>h));
            d3=((ow.alltemp[5]<<(j-h))|(ow.alltemp[4]>>h));
            d4=((ow.alltemp[3]<<(j-h))|(ow.alltemp[2]>>h));
            d5=((ow.alltemp[1]<<(j-h))|(ow.alltemp[0]>>h));
            t1=d1*config;
            t2=d2*config;
            t3=d3*config;
            t4=d4*config;
            t5=d5*config;
            // formating the webpage 
            sprintf(outBuf,"<h2>Temperature</h2><dd><dt>D1:%f</dt><br/><dt>D2:%f</dt><br/><dt>D3:%f</dt><br/><dt>D4:%f</dt><br/><dt>D5:%f</dt><br/></dd><form name=\"input\"action=\"/get\"method=\"get\"><input type=\"submit\"value=\"Refresh\"></form><dd><a href=\"/setalert\"><dt>Alarm set</dt></a><a href=\"/setreso\"><dt><br/>Resolution set</dt></a></dd>",t1,t2,t3,t4,t5);
        } else {
            sprintf(outBuf,"No device on bus!");
        }
    }//if  recive the path "setalert" eg:127.0.0.1/setalert/  we will get the alert temperture and set the alert temperture . 
    else if(strcmp(htpmsg,"/setalert")==0) {
        
        if(ow.sca[2]==0x20) {
            i=32;
        } else if(ow.sca[2]==0x30) {
            i=48;
        } else if(ow.sca[2]==0x40) {
            i=64;
        } else if(ow.sca[2]==0x50) {
            i=80;
        }//
        if(!msg.args.empty()) {
            //get the arguments from the require message
            for(iter=msg.args.begin(); iter!=msg.args.end(); iter++) {
                strncpy(h1,iter->first.c_str(),iter->first.length());//key
                strncpy(h2,iter->second.c_str(),iter->second.length());//value
            }
            temp=h2[0];
            switch(temp) {
                case '1':
                    ow.sca[2]=0x20;
                    i=32;
                    break;
                case '2':
                    ow.sca[2]=0x30;
                    i=48;
                    break;
                case '3':
                    ow.sca[2]=0x40;
                    i=64;
                    break;
                case '4':
                    ow.sca[2]=0x50;
                    i=80;
                    break;
            }
            ow.Change_Res(); //change the temp alarm
            sprintf(outBuf,"<h2>Temperture setting</h2>Now is %d.<br><br><div><form name=\"set\"action=\"/setalert\"method=\"get\">32<input type=\"radio\"name=\"s\"value=\"1\">48<input type=\"radio\"name=\"s\"value=\"2\">64<input type=\"radio\"name=\"s\"value=\"3\">80<input type=\"radio\"name=\"s\"value=\"4\"><input type=\"submit\"value=\"Submit\"></form></div><a href=\"/get\">Back</a>",i);
        } else {
            // if the server dont get the arguments just refresh the page or go into this pages from other one 
            sprintf(outBuf,"<h2>Temperture setting</h2>Now is %d.<br><br><div><form name=\"set\"action=\"/setalert\"method=\"get\">32<input type=\"radio\"name=\"s\"value=\"1\">48<input type=\"radio\"name=\"s\"value=\"2\">64<input type=\"radio\"name=\"s\"value=\"3\">80<input type=\"radio\"name=\"s\"value=\"4\"><input type=\"submit\"value=\"Submit\"></form></div><a href=\"/get\">Back</a>",i);
        }
    }//if  recive the path "setreso" eg:127.0.0.1/setreso/  we will get the resolution and set the resolution . 
    else if(strcmp(htpmsg,"/setreso")==0) {

        if(ow.sca[0]==0x1f) {
            m=9;
        } else if(ow.sca[0]==0x3f) {
            m=10;
        } else if(ow.sca[0]==0x5f) {
            m=11;
        } else if(ow.sca[0]==0x7f) {
            m=12;
        }
        if(!msg.args.empty()) {
            for(iter=msg.args.begin(); iter!=msg.args.end(); iter++) {
                strncpy(h1,iter->first.c_str(),iter->first.length());
                strncpy(h2,iter->second.c_str(),iter->second.length());
            }
            temp=h2[0];
            switch (temp) {
                case '1':
                    ow.sca[0]=0x1f;
                    m=9;
                    break;
                case '2':
                    ow.sca[0]=0x3f;
                    m=10;
                    break;
                case '3':
                    ow.sca[0]=0x5f;
                    m=11;
                    break;
                case '4':
                    ow.sca[0]=0x7f;
                    m=12;
                    break;
            }
            ow.Change_Res();//change the resolution
            sprintf(outBuf,"<h2> Resolution setting</h2>Now is %d-bit.<br><br><div><form name=\"set\" action=\"/setreso\" method=\"get\">9-bit<input type=\"radio\" name=\"s\" value=\"1\">10-bit<input type=\"radio\" name=\"s\" value=\"2\">11-bit<input type=\"radio\" name=\"s\" value=\"3\">12-bit<input type=\"radio\" name=\"s\" value=\"4\"><input type=\"submit\" value=\"Submit\"></form></div><a href=\"/get\">Back</a>",m);
        } else {
            sprintf(outBuf,"<h2> Resolution setting</h2>Now is %d-bit.<br><br><div><form name=\"set\" action=\"/setreso\" method=\"get\">9-bit<input type=\"radio\" name=\"s\" value=\"1\">10-bit<input type=\"radio\" name=\"s\" value=\"2\">11-bit<input type=\"radio\" name=\"s\" value=\"3\">12-bit<input type=\"radio\" name=\"s\" value=\"4\"><input type=\"submit\" value=\"Submit\"></form></div><a href=\"/get\">Back</a>",m);
        }
    }
    //set the web page to the web browser
    startResponse(retval, strlen(outBuf));
    processResponse(strlen(outBuf), outBuf);
    endResponse();
    err = 0;
    return err;
}


