#ifndef TOUCH_H
#define TOUCH_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bullet.h"
#include "Board.h"

// gap from edge of screen
#define GAP 2

class Touch
{

public:

    void init(int Board_width,int Board_length,int bullet_size,int speed,N5110 &lcd);
    void reading(Gamepad &pad);
    void update(Gamepad &pad,N5110 &lcd);
    void draw(N5110 &lcd);
    int _leds;
    
private:

    void Boundary_touch(Gamepad &pad);
    void Board_touch(Gamepad &pad,N5110 &lcd);
    void drop(Gamepad &pad);
    void print_scores(N5110 &lcd);
    
    Board _board;
     
    int _Board_width;
    int _Board_length;
    int _bullet_size;
    int _speed;
    
    // x positions of the Boards
    int _board_x;
    int _board_y;
    int _p1y;
    //int _leds;
    float X;//[83];
    float Y;//[24];
    int s;
    Bullet _bullet;
    
    Direction _d;
    float _mag;

};

#endif