#include "Touch.h"


//initialisation part
void Touch::init(int Board_width,int Board_length,int bullet_size,int speed,N5110 &lcd)
{
    // initialise the game parameters
    _Board_width = Board_width;         //width of board
    _Board_length = Board_length;       //length of board
    _bullet_size = bullet_size;         //bullet size
    _speed = speed;                     //speed
    _leds=0;//led number
    
    _board.init(_board_x,_board_y,_Board_length,_Board_width);     // draw board
    _bullet.init(_board_x,Board_length,_speed,_Board_length);          //draw bullet
   
}

void Touch::reading(Gamepad &pad)
{
    _d = pad.get_direction();    // joystick direction
    _mag = pad.get_mag();        // joystick direction movement parameter
}

void Touch::draw(N5110 &lcd)
{

    Vector2D bullet_pos = _bullet.get_pos();                        //bullet position data
 /*   s=0;
    if((bullet_pos.y >= 0)&&(bullet_pos.y <= 24))
    {
         //s++;
         Y[s]= bullet_pos.y ;
         X[s]= bullet_pos.x;
         s++;
    }*/
    for(int r=1;r<84;r++)
        for(int c=1;c<24;c++)
        {
            lcd.setPixel(r,c);
            if((bullet_pos.y >= 0)&&(bullet_pos.y <= 24))
            {  
                
                 Y= bullet_pos.y;
                 X= bullet_pos.x;
                 lcd.clearPixel(X,Y-1);
             /*   for(int i=0;i<s;i++)
                    lcd.clearPixel(X[i],Y[i]-1);*/
            }
        }
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT); // draw a platform for game
    print_scores(lcd);
    _board.draw(lcd);   // draw a board for game
    _bullet.draw(lcd);  // draw a bullet for game
}

void Touch::update(Gamepad &pad,N5110 &lcd)
{
    drop(pad);
    _board.update(_d,_mag);
    _bullet.update(lcd);

    Boundary_touch(pad);
    Board_touch(pad,lcd);
}

void Touch::Boundary_touch(Gamepad &pad)
{
    // read current ball attributes
    Vector2D bullet_pos = _bullet.get_pos();
    Vector2D bullet_velocity = _bullet.get_velocity();

    // check if hit top wall
    if (bullet_pos.y <= 1) {  //  1 due to 1 pixel boundary
        bullet_pos.y = 1;  // bounce off ceiling without going off screen
        bullet_velocity.y = -bullet_velocity.y;
        // audio feedback
        pad.tone(750.0,0.1);
    }
    // check if hit right wall
    else if (bullet_pos.x+_bullet_size >= 83 ) { // right wall is 83
        // hit bottom
        bullet_pos.x = (WIDTH-1) - _bullet_size;  // stops ball going off screen
        bullet_velocity.x = -bullet_velocity.x;
        // audio feedback
        pad.tone(750.0,0.1);
    }// check if hit left wall
    else if (bullet_pos.x <= 1 ) { // left wall pixel is 1
        // hit bottom
        bullet_pos.x = 1;  // stops ball going off screen
        bullet_velocity.x = -bullet_velocity.x;
        // audio feedback
        pad.tone(750.0,0.1);
    }
    // update ball parameters
    _bullet.set_velocity(bullet_velocity);
    _bullet.set_pos(bullet_pos);
}

void Touch::Board_touch(Gamepad &pad,N5110 &lcd)
{
    Vector2D bullet_pos = _bullet.get_pos();
    Vector2D bullet_velocity = _bullet.get_velocity();
    Vector2D p1_pos = _board.get_pos();
    if (
        (bullet_pos.x >= p1_pos.x) && //top
        (bullet_pos.x <= p1_pos.x + _Board_length) && //bottom
        (bullet_pos.y+_bullet_size >=p1_pos.y) //left
          //right
    ){
        
        // if it has, fix position and reflect x velocity
      //  bullet_pos.y = _boardy - _bullet_size;
        bullet_velocity.y = -bullet_velocity.y;
        // audio feedback
        pad.tone(1000.0,0.1);
        
    }
    if((bullet_pos.y >= 0)&&(bullet_pos.y <= 24))
        {
           // Y= bullet_pos.y ;
          //  X= bullet_pos.x;
           // lcd.clearPixel(X,_Y-1);
            bullet_pos.y = bullet_pos.y + _Board_width;
            bullet_velocity.y = -bullet_velocity.y;
          //  lcd.clearPixel(_x,_y-1);
        }
    // lcd.clearPixel(X,Y-1);*/
    // write new attributes
    _bullet.set_velocity(bullet_velocity);
    _bullet.set_pos(bullet_pos);
}

void Touch::drop(Gamepad &pad)
{
    Vector2D bullet_pos = _bullet.get_pos();
    
    

    // P1 has scored
    if (bullet_pos.y + _bullet_size> 47) {
        _board.add_score();
        _bullet.init(_board_x,_bullet_size,_speed,_Board_length);
        _leds++;
        if(_leds>6)
         {  
            _leds=6;
        }
        pad.led(_leds,0);
        pad.tone(1500.0,0.5);
      //  pad.leds_on();
        wait(0.5);
     //   pad.leds_off();
    }
}

void Touch::print_scores(N5110 &lcd)
{
    // get scores from Boards
    int p1_score = _board.get_score();

    // print to LCD i
    char buffer1[14];
    sprintf(buffer1,"%2d",p1_score);
    lcd.printString(buffer1,WIDTH/2 - 20,1);  // font is 8 wide, so leave 4 pixel gape from middle assuming two digits
}