#ifndef Bullet_H
#define Bullet_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Board.h"

/** Bullet Class
@author Chen Zirui, University of Leeds
@brief Bullet data and its functions list,initialisation,drawing,updating,positing setting and speed reading
@date May 2020
*/ 
class Bullet
{

public:

    void init(int x,int size,int speed,int height);              //initial datas of bullet
    void draw(N5110 &lcd);                                       //draw a bullet
    void update(N5110 &lcd);                                     //ubdate bullet position
    void set_velocity(Vector2D v);                               //velocity setting
    Vector2D get_velocity();                                     //speed data reading
    Vector2D get_pos();                                          //position reading
    void set_pos(Vector2D p);                                    //position setting
    
private:
    // all parameters about bullet
    Vector2D _velocity;
    int _size;
    int _x;
    int _y;
    float X;
    float Y;
   
};
#endif