#ifndef BOARD_H
#define BOARD_H
#define LENGTH 84
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bullet.h"
/** Board Class
@author Chen Zirui, University of Leeds
@brief Board data and its functions list
@date  May 2020
*/ 
class Board
{
public:

    void init(int x,int y,int length,int width);            //initial the first data of board
    void draw(N5110 &lcd);                                  //use screeen function to draw a board
    void update(Direction d,float mag);                     //update borad to position to realise the effect of speed
    void add_score();                                       //score generation function
    int get_score();                                        //score reading function
    Vector2D get_pos();                                     //position reading function

private:
    //all parameters about board
    int _length;
    int _width;
    int _x;
    int _y;
    int _speed;
    int _score;
    
};
#endif